package gov.va.med.fee.dao;

import java.util.List;

import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

import gov.va.med.domain.fee.WsFacStatus;

/**
 * 
 * @author Muneshwar Baiah
 *
 */

@Repository
public interface IClaimByStatusCodeRepository extends JpaRepository<WsFacStatus, Long>{
	
	/**
	 * @param claimStatusCode
	 * @param activeStations
	 * @param privacyRestrictions
	 * @return
	 */
	@Query("select c from fWsFacStatus c where c.claimStatusCd = :claimStatusCode and (c.vaFacilityCd IN :activeStationList or c.visnIdCd IN :visns) and c.personId NOT IN :privacyRestrictionsList")
	List<WsFacStatus> findAwaitingProcessingClaims(@Param("claimStatusCode") String claimStatusCode, @Param("activeStationList") List<String> activeStationList,@Param("privacyRestrictionsList") List<String> privacyRestrictionsList, @Param("visns") List<Long> visns);

	/**
	 * @param claimStatusCode
	 * @param activeStations
	 * @param privacyRestrictions
	 * @return
	 */
	@Query("select c from fWsFacStatus c where c.claimStatusCd != :claimStatusCode and (c.vaFacilityCd IN :activeStationList or c.visnIdCd IN :visns) and c.personId NOT IN :privacyRestrictionsList and c.dateCreated < (SYSDATE - 30)")
	List<WsFacStatus> findAgedClaims(@Param("claimStatusCode") String claimStatusCode, @Param("activeStationList") List<String> activeStationList,@Param("privacyRestrictionsList") List<String> privacyRestrictions, @Param("visns") List<Long> visns);

}
