package gov.va.med.fee.dao;

import java.util.List;

import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

import gov.va.med.domain.fee.AppUserRequest;

@Repository
public interface IAppUserRequestRepository extends JpaRepository<AppUserRequest, Long> {
	
	/**
	 * Get APPUserRequest by UserName
	 * @param userName
	 * @return
	 */
	@Query("SELECT u FROM fAppUserRequest u WHERE u.userName = :username")
	List<AppUserRequest> findByAppUserName(@Param("username") String userName);

}
