
package gov.va.med.fee.dao;

import java.util.List;

import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

import gov.va.med.domain.fee.AppUser;

/**
 *  @author Eyuel Taddese
 *
 */

@Repository
public interface IAppUserRepository extends JpaRepository<AppUser, Long> {
	
	/**
	 * Get APPUser by UserName
	 * @param userName
	 * @return
	 */
	@Query("SELECT u FROM fAppUser u JOIN FETCH u.userRoleUsages r JOIN FETCH r.appRole a WHERE u.userName = :username")
	List<AppUser> findByAppUserName(@Param("username") String userName);
}
