package gov.va.med.fee.dao;

import java.util.List;

import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

import gov.va.med.domain.fee.AdjustmentReason;

@Repository
public interface IAdjustmentReasonRepository extends JpaRepository<AdjustmentReason, String> {

	@Query("select ar from fAdjustmentReason ar where ar.adjustmentReasonCd =:adjustmentReasonCd")
	public AdjustmentReason findAdjustmentReason(@Param("adjustmentReasonCd") String adjustmentReasonCd);
	
	@Query("select ar from fAdjustmentReason ar where ar.activeFlag = 'Y'")
	public List<AdjustmentReason> findAllActiveAdjustmentReasons();

	@Query(value = "SELECT DISTINCT CRC.CARC_ID AS ADJUSTMENT_REASON_CD, AR.DESCRIPTION, CRC.CAGC AS CREATED_BY, CRC.BUSINESS_RULE AS FEE_USAGE_FLAG " +
			"FROM FPPS_OWNER.ADJUSTMENT_REASON AR JOIN FPPS_OWNER.CARC_RARC_CROSSWALK CRC " +
			"ON AR.ADJUSTMENT_REASON_CD = CRC.CARC_ID " +
			"WHERE CRC.CAGC = :groupCode " +
			"AND AR.ACTIVE_FLAG = 'Y' "+
			"GROUP BY CRC.CARC_ID, AR.DESCRIPTION, CRC.CAGC, CRC.BUSINESS_RULE  " +
			"UNION  " +
			"SELECT AR2.ADJUSTMENT_REASON_CD AS ADJUSTMENT_REASON_CD, AR2.DESCRIPTION, TO_CHAR(NULL) AS CREATED_BY, 0 AS FEE_USAGE_FLAG " +
			"FROM FPPS_OWNER.ADJUSTMENT_REASON AR2 " +
			"WHERE AR2.ADJUSTMENT_REASON_CD NOT IN " +
			"(SELECT CRC2.CARC_ID FROM FPPS_OWNER.CARC_RARC_CROSSWALK CRC2 GROUP BY CRC2.CARC_ID)	" +
			"AND AR2.ACTIVE_FLAG = 'Y' " +
			"GROUP BY AR2.ADJUSTMENT_REASON_CD, AR2.DESCRIPTION " +
			"ORDER BY ADJUSTMENT_REASON_CD ASC ", nativeQuery = true)
	public List<AdjustmentReason> findAdjustmentReasonByGroupCode(@Param("groupCode") String groupCode);
}
