/**
 * 
 */
package gov.va.med.fee.dao;

import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

import gov.va.med.domain.fee.PayerInfo;

/**
 * @author Vamsi Krishna Gangarapu
 *
 */
@Repository
public interface IAdditionalInfoRepository extends JpaRepository<PayerInfo, Long> {

	/**
	 * @param claimIndex
	 * @param payerType
	 * @return
	 */
	@Query("select p from fPayerInfo p JOIN p.payerType f JOIN p.claim c where c.claimIndex= :claimIndex AND f.payerTypeCd= :payerType ")
	PayerInfo findPayerInfoByClaimIndex(@Param("claimIndex") Long claimIndex, @Param("payerType") String payerType);
	
}
