package gov.va.med.fee.controller;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

import gov.va.med.fee.model.request.UserSearchRequest;
import gov.va.med.fee.model.response.UserSearchPage;
import gov.va.med.fee.service.IUserSearchService;
import gov.va.med.fee.vo.ErrorVo;

@RestController
@RequestMapping("/api/v1/user")
public class UserSearchController {
	
	@Autowired
	IUserSearchService iUserSearchService;
	
	private static final Logger log = LogManager.getLogger(UserSearchController.class);
	
	/**
	 * This method is used for search a user by search parameter 
	 * @param UserSearchRequest
	 * @return UserSearchResponse
	 */
	
	@RequestMapping(value = "/search", method = RequestMethod.POST)
	public ResponseEntity<?> searchUser(@RequestBody UserSearchRequest userSearchRequest) {
		
        ResponseEntity<?> response = null;
        try {

        	UserSearchPage userSearchPage = iUserSearchService.searchUser(userSearchRequest);
        	response = new ResponseEntity<UserSearchPage>(userSearchPage, HttpStatus.OK);
            log.info("Search successful ");

        } catch (Exception e) {
        	
            log.error("Error occured in search for an user request: " + e.getMessage());
            ErrorVo vo = new ErrorVo("ERR", "There was an error while searching for an user, "
            		+ "please contact support.");
            response = new ResponseEntity<ErrorVo>(vo, HttpStatus.INTERNAL_SERVER_ERROR);
        }        
        return response;		
	}	
}