/**
 * 
 */
package gov.va.med.fee.controller;

import java.util.List;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

import gov.va.med.fee.exceptions.GenericException;
import gov.va.med.fee.model.request.UnmatchedClaimPaymentRequest;
import gov.va.med.fee.model.request.UnmatchedReconciliationRequest;
import gov.va.med.fee.model.response.UnmatchedClaimPaymentsResponse;
import gov.va.med.fee.model.response.UnmatchedClaimReconciliationResponse;
import gov.va.med.fee.service.IUnmatchedReconciliationService;

/**
 * @author Vamsi Krishna Gangarapu
 *
 */
@RestController
@RequestMapping("/api/v1/reconciliation/unmatchedClaim")
public class UnmatchedClaimReconciliationController {

	private static final Logger logger = LogManager.getLogger(UnmatchedClaimReconciliationController.class);

	@Autowired
	IUnmatchedReconciliationService iUnmatchedReconciliationService;

	@RequestMapping(value = "/{claimIndex}", method = RequestMethod.GET, produces = "application/json")
	public ResponseEntity<?> getClaimsToReconcile(@PathVariable("claimIndex") String claimIndex) throws GenericException {
		try {
			logger.info("Into the UnmatchedClaimReconciliationController:getClaimsToReconcile()");
			Long claimId = Long.parseLong(claimIndex);
			UnmatchedClaimPaymentsResponse claimInformation = iUnmatchedReconciliationService
					.getUnmatchedClaimsInformation(claimId);
			logger.info("UnmatchedClaimReconciliationController:getClaimsToReconcile() response String "
					+ claimInformation.toString());
			return new ResponseEntity<>(claimInformation, HttpStatus.OK);
		} catch (Exception e) {

			throw e;
		}

	}

	@RequestMapping(value = "/claimPayments", method = RequestMethod.POST, produces = "application/json")
	public ResponseEntity<List<UnmatchedClaimPaymentsResponse>> getclaimPaymentsInformation(
			@RequestBody UnmatchedReconciliationRequest unmatchedReconciliationRequest) throws GenericException {
		try {
			logger.info("Into the UnmatchedClaimReconciliationController:getclaimPaymentsInformation() ");
			List<UnmatchedClaimPaymentsResponse> unmatchedClaimPaymentsResponse = iUnmatchedReconciliationService
					.getUnmatchedClaimPayments(unmatchedReconciliationRequest);
			logger.info("UnmatchedClaimReconciliationController:getclaimPaymentsInformation() response String "
					+ unmatchedClaimPaymentsResponse.toString());
			return new ResponseEntity<>(unmatchedClaimPaymentsResponse, HttpStatus.OK);
		} catch (Exception e) {
			throw e;
		}
	}

	@RequestMapping(value = "/paymentLines/{feeClaimPaymentId}", method = RequestMethod.GET, produces = "application/json")
	public ResponseEntity<UnmatchedClaimReconciliationResponse> getclaimPaymentLines(
			@PathVariable("feeClaimPaymentId") String feeClaimPaymentId) throws GenericException {
		try {
			logger.info("Into the UnmatchedClaimReconciliationController:getclaimPaymentLines()");
			UnmatchedClaimReconciliationResponse paymentLineItemsResponse = iUnmatchedReconciliationService
					.getPaymentLineItems(feeClaimPaymentId);
			logger.info("UnmatchedClaimReconciliationController:getclaimPaymentLines() response String "
					+ paymentLineItemsResponse.toString());
			return new ResponseEntity<>(paymentLineItemsResponse, HttpStatus.OK);
		} catch (Exception e) {
			throw e;
		}
	}

	@RequestMapping(value = "/editpaymentInformation", method = RequestMethod.POST, produces = "application/json")
	public ResponseEntity<UnmatchedClaimReconciliationResponse> setEditPaymentInformation(
			@RequestBody UnmatchedClaimPaymentRequest unmatchedClaimPaymentRequest) throws GenericException {
		try {
			logger.info("Into the UnmatchedClaimReconciliationController:setEditPaymentInformation()");
			UnmatchedClaimReconciliationResponse submitEditPaymentInfo = iUnmatchedReconciliationService
					.EditPaymentInformation(unmatchedClaimPaymentRequest);
			logger.info("Into the UnmatchedClaimReconciliationController:setEditPaymentInformation() response String "
					+ submitEditPaymentInfo.toString());
			return new ResponseEntity<>(submitEditPaymentInfo, HttpStatus.OK);

		} catch (Exception e) {
			throw e;
		}
	}

	@RequestMapping(value = "/editpaymentInformation/{feeClaimPaymentLineId}", method = RequestMethod.GET, produces = "application/json")
	public ResponseEntity<UnmatchedClaimPaymentRequest> getPaymentInformation(
			@PathVariable("feeClaimPaymentLineId") String feeClaimPaymentLineId) throws GenericException {
		try {
			logger.info("Into the UnmatchedClaimReconciliationController:getPaymentInformation()");
			UnmatchedClaimPaymentRequest unmatchedClaimPaymentRequest = iUnmatchedReconciliationService
					.getEditPaymentInformation(feeClaimPaymentLineId);
			logger.info("Into the UnmatchedClaimReconciliationController:getPaymentInformation() response String "
					+ unmatchedClaimPaymentRequest.toString());
			return new ResponseEntity<>(unmatchedClaimPaymentRequest, HttpStatus.OK);
		} catch (Exception e) {
			throw e;
		}
	}

}
