package gov.va.med.fee.controller;

import java.util.ArrayList;
import java.util.List;



import javax.validation.Valid;
import javax.validation.constraints.NotNull;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;
import gov.va.med.domain.fee.PrivacyToPerson;
import gov.va.med.fee.exceptions.GenericException;
import gov.va.med.fee.model.request.PrivacyRestrictionRequest;
import gov.va.med.fee.service.IPrivacyRestrictionService;
import gov.va.med.fee.vo.ErrorVo;

/**
 * 
 * @author DNS   YIBRIK
 * email : yibriekedir@gmail.com
 * 
 */

@RestController
@RequestMapping("/api/v1/privacyRestrictions")
public class PrivacyRestrictionsController {

	@Autowired
	IPrivacyRestrictionService privacyRestrictionService;
	
	private static final Logger log = LogManager.getLogger(PrivacyRestrictionsController.class);

	
	/**
	 *  
	 * @return list of privacyRestrictions from DB
	 * A rest GET Method to get all privacy restrictions 
	 */
	
    @RequestMapping(method = RequestMethod.GET)
    public ResponseEntity<?> getAll() {
		List<PrivacyToPerson> result = null;
		ResponseEntity<?> resultResponse = null;
		try {
			result = privacyRestrictionService.getAllRestrictions();

			resultResponse = new ResponseEntity<List<PrivacyToPerson>>(result, HttpStatus.OK);
			log.info("Successfully getting all PrivacyRestriction : ");

		} catch (GenericException e) {
			log.error("There was an error in Getting all PrivacyRestrictions, please contact support.", e);
		}
		return resultResponse;
    }
   
    /**
     * 
     * @param requestId
     * @return boolean response : True if the privacy to person is removed from DB
     */
     
    @RequestMapping(value = "delete/{requestId}", method = RequestMethod.DELETE)
    public ResponseEntity<?> delete(@PathVariable("requestId") int requestId) {
		boolean result = false;
		ResponseEntity<?> resultResponse = null;
		try {
			result = privacyRestrictionService.deleteRestriction(requestId);
			if(result){
				log.info("Successfully deleted PrivacyRestriction for request id: " + requestId);
				return resultResponse = new ResponseEntity<Boolean>(result, HttpStatus.OK);
				
			}else{
				
				log.info("Successfully deleted PrivacyRestriction for request id: " + requestId);
				return resultResponse = new ResponseEntity<Boolean>(result, HttpStatus.OK);
				
			}

		} catch (GenericException e) {
			log.error("There was an error in deleting PrivecyRestriction, please contact support."+ requestId, e);			
		}
		return resultResponse;
	}
    /**
     * 
     * @param req
     * @return response String " Privacy restriction added"
     * @throws GenericException
     */
    
    @RequestMapping(value = "/create", method = RequestMethod.POST)
     public ResponseEntity<?> createPrivacyRestriction(@RequestBody @Valid PrivacyRestrictionRequest req,BindingResult br	)throws GenericException {
    	
    	
    	boolean result = false;
        ResponseEntity<?> resultResponse = null;
    	if(br.hasErrors()) {
			throw new GenericException("Request has validation errors","", HttpStatus.BAD_REQUEST);
		
		}else{
    
        try {

        	String claims = privacyRestrictionService.checkClaim(req.getNtName(), req.getSsn());
        	if(!claims.equalsIgnoreCase("")){
        		log.error("ERR", "Error:\n User has assigned claims associated with that SSN. These claims must be rerouted before a restriction can be added\n:"+claims);
        		return  new ResponseEntity<Boolean>(result, HttpStatus.BAD_REQUEST);
        	}
            if(privacyRestrictionService.checkExist(req.getNtName(), req.getSsn())){
            	log.error("ERR", "Error:\n That NT Username is already restricted from that SSN.");
            	return  new ResponseEntity<Boolean>(result, HttpStatus.BAD_REQUEST);
        	}

        	result  = privacyRestrictionService.addPrivacyRestriction(req); 
        	if(result){
        		
        		 resultResponse = new ResponseEntity<Boolean>(result, HttpStatus.CREATED);
        		 log.info("Successfully created PrivacyRestriction : " + req.toString());
        	}else{
        		
        		resultResponse = new ResponseEntity<Boolean>(result, HttpStatus.BAD_REQUEST);
                log.error(" creating PrivacyRestriction Failed: " + req.toString());
        	}
        	
        	
        } catch (GenericException e) {
            log.error("There was an error in creating app user request, please contact support." + req.toString(), e);
        }
        return resultResponse;
    }
   }

}
