package gov.va.med.fee.controller;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

import gov.va.med.fee.exceptions.GenericException;
import gov.va.med.fee.exceptions.ValidationException;
import gov.va.med.fee.model.request.ManualReconRequest;
import gov.va.med.fee.model.response.ManualReconResponse;
import gov.va.med.fee.service.IManualReconClaimService;

@RestController
@RequestMapping("/api/v1/manualRecon")
public class ManualReconClaimController {

	@Autowired
	IManualReconClaimService manualReconClaimService;

	private static final Logger logger = LogManager.getLogger(ManualReconClaimController.class);
	
	/**
	 * Get claim details for the given claim
	 * @return Claim details along with line items
	 * @throws GenericException
	 */
	@RequestMapping(value = "{claimId}", method = RequestMethod.GET, produces = "application/json")
	public ResponseEntity<ManualReconResponse> getClaimDetails(@PathVariable("claimId") long claimId) throws GenericException {
		
		logger.info("getClaimDetails()");
		
		try {			
			ManualReconResponse manualReconResponse = manualReconClaimService.getClaimDetails(claimId);

			return new ResponseEntity<ManualReconResponse>(manualReconResponse, HttpStatus.OK);
			
		} catch (GenericException e) {
			logger.error("getClaimDetails() exception occured : "
					+" - " + e.getMessage());
			
			throw e; 
		}
	}
	
	/**
	 * Submit manual reconciliation out of system payment
	 * @param manualReconRequest request with the information from the form
	 * @return Claim details along with line items
	 * @throws GenericException
	 */
	@RequestMapping(method = RequestMethod.POST, produces = "application/json")
	public ResponseEntity<ManualReconResponse> submitManualRecon(@RequestBody ManualReconRequest manualReconRequest)
			throws GenericException, ValidationException {
		logger.info("submitManualRecon()");
		
		try {			
			ManualReconResponse manualReconResponse = manualReconClaimService.submitManualRecon(manualReconRequest);

			return new ResponseEntity<ManualReconResponse>(manualReconResponse, HttpStatus.OK);
			
		} catch (GenericException e) {
			logger.error("submitManualRecon() exception occured : "
					+" - " + e.getMessage());
			
			throw e; 
		}
	}
}
