package gov.va.med.fee.controller;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

import gov.va.med.fee.exceptions.GenericException;
import gov.va.med.fee.model.request.CodeLookupRequest;
import gov.va.med.fee.model.response.GenericResponse;
import gov.va.med.fee.service.ICodeLookupService;

/**
 * @author Vamsi Krishna Gangarapu
 *
 * @author Muneshwar Baiah - Added the functionality for DiagnosisCodeLookup as part of Build2Sprint3
 * 
 */
@RestController
@RequestMapping("/api/v1")
public class CodeLookupController {

	private static final Logger logger = LogManager.getLogger(CodeLookupController.class);

	@Autowired
	ICodeLookupService iCodeLookupService;


	/**
	 * @param codeLookupRequest
	 * @return
	 * @throws GenericException
	 */
	@RequestMapping(value = "tools/medicalCodes", method = RequestMethod.POST, produces = "application/json")
	public ResponseEntity<GenericResponse> getMedicalCodes(@RequestBody CodeLookupRequest codeLookupRequest) throws GenericException {
		try {
			logger.info("getMedicalCodes() : Received the request to retreive medical codes");
			GenericResponse medicalCodes = iCodeLookupService.getMedicalCodes(codeLookupRequest.getCode(), codeLookupRequest.getCodeType(), codeLookupRequest.getPageSize(),codeLookupRequest.getSortColumn(), codeLookupRequest.getDescending(), codeLookupRequest.getPageNumber());
			logger.debug("getMedicalCodes() : Response from iCodeLookupService.getMedicalCodes is :"+medicalCodes);
			return new ResponseEntity<GenericResponse>(medicalCodes, HttpStatus.OK);
		} catch (GenericException e) {
			logger.error("getMedicalCodes() : exception occured : "
					+" - " + e.getMessage());
			throw e;
		}
	}



	/**
	 * @param codeLookupRequest
	 * @return
	 * @throws GenericException
	 */
	@RequestMapping(value = "tools/diagnosisCodes", method = RequestMethod.POST, produces = "application/json")
	public ResponseEntity<GenericResponse> getDignosisCodes(@RequestBody CodeLookupRequest codeLookupRequest) 
			throws GenericException {
		try {
			logger.info("getDignosisCodes() : Received the request to retreive diagnosis codes");
			GenericResponse diagnosisCodes = iCodeLookupService.getDiagnosisCodes(codeLookupRequest.getCode(), codeLookupRequest.getCodeType(), codeLookupRequest.getPageSize(),codeLookupRequest.getSortColumn(), codeLookupRequest.getDescending(), codeLookupRequest.getPageNumber());
			logger.debug("getDignosisCodes() : Response from iCodeLookupService.getDiagnosisCodes is :"+diagnosisCodes);
			return new ResponseEntity<GenericResponse>(diagnosisCodes, HttpStatus.OK);
		} catch (GenericException e) {
			logger.error("getDignosisCodes() : Exception occured : "
					+" - " + e.getMessage());
			throw e;
		}
	}
}
