/**
 * 
 */
package gov.va.med.fee.controller;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

import gov.va.med.fee.exceptions.GenericException;
import gov.va.med.fee.model.request.ClaimSearchProcessingRequest;
import gov.va.med.fee.model.response.ClaimSearchResponse;
import gov.va.med.fee.model.response.GenericResponse;
import gov.va.med.fee.service.IClaimSearchService;

/**
 * @author Vamsi Krishna Gangarapu
 *
 */
@RestController
@RequestMapping("api/v1")
public class ClaimSearchController {

	private static final Logger logger = LogManager.getLogger(ClaimSearchController.class);
	
	@Autowired
	IClaimSearchService iClaimSearchService;
	
	@RequestMapping(value = "/claimSearch", method = RequestMethod.POST, produces = "application/json")
	public ResponseEntity<GenericResponse> ClaimSearch(@RequestBody ClaimSearchProcessingRequest claimSearchProcessingRequest) throws GenericException{
		try {
			GenericResponse claimSearchResponse = iClaimSearchService.getClaimSearchResults(claimSearchProcessingRequest);
			return new ResponseEntity<>(claimSearchResponse, HttpStatus.OK);
		} catch (GenericException e) {
			logger.error("getClaimSearchResults() exception occured : "
					+" - " + e.getMessage());
			throw e;
		}
	}
	
	@RequestMapping(value = "/claimSearch/{claimId}", method = RequestMethod.GET, produces = "application/json")
	public ResponseEntity<ClaimSearchResponse> ClaimSearch(@PathVariable String claimId) throws GenericException{
		try {
			ClaimSearchResponse claimSearchResponse = iClaimSearchService.getOneClaimSearchResults(claimId);
			return new ResponseEntity<>(claimSearchResponse, HttpStatus.OK);
		} catch (GenericException e) {
			logger.error("getClaimSearchResults() exception occured : "
					+" - " + e.getMessage());
			throw e;
		}
	}
}
