package gov.va.med.fee.controller;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

import gov.va.med.fee.exceptions.GenericException;
import gov.va.med.fee.model.response.ClaimDetailsResponse;
import gov.va.med.fee.service.IClaimDetailsService;
import gov.va.med.fee.validators.ClaimDetailsValidator;


/**
 * 
 * @author Vamsi Krishna Gangarapu 
 * @author Muneshwar Baiah 
 * This is the controller for the below API's 
 * 1. Claim API - This API returns the Claim Id, claim status, Patient control number and Pre-Authorization number 
 * 2. Pay To Provider Info API - This API returns all the fields which are required to show Pay to Provider Info card
 * 3. Billing Provider Info API - This API returns all the fields which are required to show Billing Provider Info card
 * 4. Veteran Info API - This API returns all the fields which are required to show Veteran Info card
 * 5. Service Provider Info API - This API returns all the fields which are required to show Service Provider Info card
 * All these API handles all three types of claims such as professional, dental and institutional.
 * 
 */
@RestController
@RequestMapping("api/v1/claim")
public class ClaimDetailsController {

	@Autowired
	IClaimDetailsService claimDetailsService;

	private static final Logger logger = LogManager.getLogger(ClaimDetailsController.class);

	/**
	 * Returns all the claim details
	 * @param claimIndex
	 * @return claimDetailsResponse in the JSON format
	 * @throws GenericException
	 */
	@RequestMapping(value = "/{claimIndex}", method = RequestMethod.GET, produces = "application/json")
	public ResponseEntity<ClaimDetailsResponse> getClaimDetailsByIndex(@PathVariable("claimIndex") String claimIndex) throws GenericException {
		Long claimNumber = null;
		Boolean isValid;
	
		ClaimDetailsResponse claimDetailsResponse = null;
		try {
			ClaimDetailsValidator claimDetailsValidator = new ClaimDetailsValidator();
			isValid = claimDetailsValidator.returnClaimNumber(claimIndex);
			if(isValid == true){
				claimNumber = Long.valueOf(claimIndex);
			}
			logger.info(
					"ClaimDetailsController:getClaimDetailsByIndex() received the request for claim index :" + claimIndex);
			
			logger.debug(
					"ClaimDetailsController:getClaimDetailsByIndex() invoking the claimDetailsService.getClaimDetailsByClaimIndex() for claim index"
							+ claimIndex);
			claimDetailsResponse = claimDetailsService.getClaimDetailsByClaimIndex(claimNumber);
			logger.debug(
					"ClaimDetailsController:getClaimDetailsByIndex() claimDetailsResponse is :" + claimDetailsResponse);
			return new ResponseEntity<ClaimDetailsResponse>(claimDetailsResponse, HttpStatus.OK);
		} catch (GenericException e) {
			logger.error("ClaimDetailsController:getClaimDetailsByIndex() exception occured for claim index : "
					+ claimIndex + " - " + e.getMessage());
			throw e;
		}
	}

}
