package gov.va.med.fee.controller;

import java.util.List;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

import gov.va.med.fee.constants.ClaimDetailsConstants;
import gov.va.med.fee.exceptions.GenericException;
import gov.va.med.fee.model.request.ClaimRequest;
import gov.va.med.fee.model.response.ClaimDetailsResponse;
import gov.va.med.fee.model.response.ClaimLineItems;
import gov.va.med.fee.model.response.ClaimRejectedResponse;
import gov.va.med.fee.model.response.ClaimResponse;
import gov.va.med.fee.service.IClaimService;

/**
 * 
 * @author Muneshwar Baiah 
 * Controller for retrieving and updating claims
 * 
 */

@RestController
@RequestMapping("/api/v1")
public class ClaimController {

	@Autowired
	IClaimService claimService;

	private static final Logger logger = LogManager.getLogger(ClaimController.class);

	
	/**
	 * Retrieve all the claims in the ESTABLISH status
	 * @param claimRequest
	 * @return
	 * @throws GenericException
	 */
	@RequestMapping(value = "/awaitingProcessing", method = RequestMethod.POST, produces = "application/json")
	public ResponseEntity<List<ClaimResponse>> getAwaitingProcessingClaims(@RequestBody ClaimRequest claimRequest)
			throws GenericException {
			logger.info(
				"getAwaitingProcessingClaims received the request with claimRequest :"+claimRequest);
		try { 
			logger.debug(
					"getAwaitingProcessingClaims invoking claimService.getAwaitingProcessingClaims()");
			List<ClaimResponse> claimResponse = claimService.getClaimsByStatus(claimRequest,ClaimDetailsConstants.AWAITING_STATUS_CODE);
			logger.debug(
					"getAwaitingProcessingClaims claimResponse is :" + claimResponse);
			return new ResponseEntity<>(claimResponse, HttpStatus.OK);
		} catch (GenericException e) {
			logger.error("getAwaitingProcessingClaims exception occured : "
					+" - " + e.getMessage());
			throw e;
		}
	}
	
	/**
	 * Update claims status to in process
	 * @param ids selected claim id's
	 * @return update list of claims
	 * @throws GenericException
	 */
	@RequestMapping(value = "/awaitingProcessing/processClaims", method = RequestMethod.POST, produces = "application/json")
	public ResponseEntity<List<ClaimResponse>> updateClaimsStatusToInProcess(@RequestBody ClaimRequest claimRequest)
			throws GenericException {
			logger.info(
				"updateClaimsStatusToInProcess received the request with claimRequest :"+claimRequest);
		try { 
			List<ClaimResponse> claimResponse = claimService.updateClaimsStatus(claimRequest, ClaimDetailsConstants.INPROCESS_STATUS_CODE);
			
			logger.debug("updateClaimsStatusToInProcess :", claimResponse);
			return new ResponseEntity<>(claimResponse, HttpStatus.OK);
		} catch (GenericException e) {
			logger.error("updateClaimsStatusToInProcess exception occured : "
					+" - " + e.getMessage());
			throw e;
		}
	}

	/**
	 * Retrieve all the claims in the ESTABLISH status
	 * @param claimRequest
	 * @return
	 * @throws GenericException
	 */
	@RequestMapping(value = "/inprocess", method = RequestMethod.POST, produces = "application/json")
	public ResponseEntity<List<ClaimResponse>> getInProcessClaims(@RequestBody ClaimRequest claimRequest)
			throws GenericException {
			logger.info(
				"getInProcessClaims received the request with claimRequest :"+claimRequest);
		try { 
			logger.debug(
					"getInProcessClaims invoking claimService.getClaimsByStatus()");
			List<ClaimResponse> claimResponse = claimService.getClaimsByStatus(claimRequest,ClaimDetailsConstants.INPROCESS_STATUS_CODE);
			logger.debug(
					"getInProcessClaims claimResponse is :" + claimResponse);
			return new ResponseEntity<>(claimResponse, HttpStatus.OK);
		} catch (GenericException e) {
			logger.error("getInProcessClaims exception occured : "
					+" - " + e.getMessage());
			throw e;
		}
	}
	
	/**
	 * Retrieve all the claims in the ESTABLISH status
	 * @param claimRequest
	 * @return
	 * @throws GenericException
	 */
	@RequestMapping(value = "/claims/rejected", method = RequestMethod.POST, produces = "application/json")
	public ResponseEntity<List<ClaimRejectedResponse>> getClaimsRejected(@RequestBody ClaimRequest claimRequest)
			throws GenericException {
		logger.info(
				"getClaimsRejected received the request with claimRequest:"+claimRequest);
		try { 
			logger.debug(
					"getClaimsRejected invoking claimService.getClaimsByStatus()");
			List<ClaimRejectedResponse> claimRejectedResponse = claimService.getClaimsRejected(claimRequest, ClaimDetailsConstants.REJECTED_STATUS_CODE);
			logger.debug(
					"getClaimsRejected claimResponse is :" + claimRejectedResponse);
			return new ResponseEntity<>(claimRejectedResponse, HttpStatus.OK);
		} catch (GenericException e) {
			logger.error("getClaimsRejected exception occured : "
					+" - " + e.getMessage());
			throw e;
		}		
	}
	
/*	private ResponseEntity<List<ClaimResponse>> getClaimsByStatus(@RequestBody ClaimRequest claimRequest, String claimStatus)
			throws GenericException {
			logger.info(
				"getClaimsByStatus received the request with claimRequest:"+claimRequest);
		try { 
			logger.debug(
					"getClaimsByStatus invoking claimService.getClaimsByStatus()");
			List<ClaimResponse> claimResponse = claimService.getClaimsByStatus(claimRequest, claimStatus);
			logger.debug(
					"getClaimsByStatus claimResponse is :" + claimResponse);
			return new ResponseEntity<>(claimResponse, HttpStatus.OK);
		} catch (GenericException e) {
			logger.error("getClaimsByStatus exception occured : "
					+" - " + e.getMessage());
			throw e;
		}
	}*/

	/**
	 * Retrieve all the claims in the ESTABLISH status
	 * @param claimRequest
	 * @return
	 * @throws GenericException
	 */
	@RequestMapping(value = "/aged", method = RequestMethod.POST, produces = "application/json")
	public ResponseEntity<List<ClaimResponse>> getAgedClaims(@RequestBody ClaimRequest claimRequest)
			throws GenericException {
			logger.info(
				"getAgedClaims received the request with claimRequest :"+claimRequest);
		try { 
			logger.debug(
					"getAgedClaims invoking claimService.getClaimsByStatus()");
			List<ClaimResponse> claimResponse = claimService.getClaimsByStatus(claimRequest,ClaimDetailsConstants.AGED_STATUS_CODE);
			logger.debug(
					"getAgedClaims claimResponse is :" + claimResponse);
			return new ResponseEntity<>(claimResponse, HttpStatus.OK);
		} catch (GenericException e) {
			logger.error("getAgedClaims exception occured : "
					+" - " + e.getMessage());
			throw e;
		}
	}

	/**
	 * Update the claim in the ESTABLISH status to INPROCESS
	 * @return the updated claim
	 * @throws GenericException
	 */
	@RequestMapping(value = "/awaitingProcessing/processClaim", method = RequestMethod.POST, produces = "application/json")
	public ResponseEntity<ClaimDetailsResponse> updateClaimStatusToInProcess(@RequestBody ClaimRequest claimRequest)
			throws GenericException {
		logger.info(
				"updateClaimStatusToInProcess received the request with claimRequest :"+claimRequest);
		try { 
			ClaimDetailsResponse claimDetailsResponse = claimService.updateClaimStatus(claimRequest, ClaimDetailsConstants.INPROCESS_STATUS_CODE);
			
			logger.debug("updateClaimStatusToInProcess :", claimDetailsResponse);
			return new ResponseEntity<>(claimDetailsResponse, HttpStatus.OK);
		} catch (GenericException e) {
			logger.error("updateClaimStatusToInProcess exception occured : "
					+" - " + e.getMessage());
			throw e;
		}
	}

	/**
	 * Retrieve all the line items for a given claim
	 * @param claimRequest
	 * @return
	 * @throws GenericException
	 */
	@RequestMapping(value = "/claim/lineItems/{claimId}", method = RequestMethod.GET, produces = "application/json")
	public ResponseEntity<ClaimLineItems> getClaimLineItems(@PathVariable("claimId") long claimId)
			throws GenericException {
		logger.info(
				"getClaimLineItems for the claim id:"+claimId);
		try { 
			logger.debug(
					"getClaimLineItems invoking claimService.getClaimLineItems()");
			ClaimLineItems claimLineItems = claimService.getClaimLineItems(claimId);
			logger.debug(
					"getClaimLineItems size :" + (claimLineItems.getClaimLineItems() != null ? claimLineItems.getClaimLineItems().size() : claimLineItems));
			return new ResponseEntity<>(claimLineItems, HttpStatus.OK);
		} catch (GenericException e) {
			logger.error("getClaimLineItems exception occured : "
					+" - " + e.getMessage());
			throw e;
		}		
	}	
}
