/**
 * 
 */
package gov.va.med.fee.controller;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

import gov.va.med.fee.exceptions.GenericException;
import gov.va.med.fee.model.response.AdjustmentsResponse;
import gov.va.med.fee.model.response.AdjustmentsResponses;
import gov.va.med.fee.service.IAdjustmentsService;

/**
 * @author Vamsi Krishna Gangarapu
 *
 */
@RestController
@RequestMapping("/api/v1/adjustments")
public class AdjustmentsController {

	private static final Logger logger = LogManager.getLogger(AdjustmentsController.class);
	
	@Autowired
	IAdjustmentsService iGenericResponseService;
	
	/**
	 * Get all reason code
	 * @return a list of reason codes
	 * @throws GenericException
	 */
	@RequestMapping(value = "/reasons", method = RequestMethod.GET, produces = "application/json")
	public ResponseEntity<AdjustmentsResponse> populateAdjustmentReasons() throws GenericException {
		
		logger.info("populateAdjustmentReasons()");
		
		try {
			AdjustmentsResponse adjustmentReasons = iGenericResponseService.populateAdjustmentReasons();
			
			logger.debug("populateAdjustmentReasons() :", adjustmentReasons.toString());
			return new ResponseEntity<AdjustmentsResponse>(adjustmentReasons, HttpStatus.OK);
			
		} catch (GenericException e) {
			logger.error("populateAdjustmentReasons() exception occured : "
					+" - " + e.getMessage());
			
			throw e; 
		}
	}
	
	@RequestMapping(value = "/groups", method = RequestMethod.GET, produces = "application/json")
	public ResponseEntity<AdjustmentsResponse> populateAdjustmentGroups() throws GenericException {
		
		logger.info("populateAdjustmentReasons()");
		
		try {
			AdjustmentsResponse adjustmentGroups = iGenericResponseService.populateAdjustmentGroups();
			
			logger.debug("populateAdjustmentReasons() :", adjustmentGroups.toString());
			return new ResponseEntity<AdjustmentsResponse>(adjustmentGroups, HttpStatus.OK);
			
		} catch (GenericException e) {
			logger.error("populateAdjustmentReasons() exception occured : "
					+" - " + e.getMessage());
			
			throw e; 
		}
	}
	
	@RequestMapping(value = "/adjgroups", method = RequestMethod.GET, produces = "application/json")
	public ResponseEntity<AdjustmentsResponses> getAdjustmentGroups() throws GenericException {
		
		logger.info("getAdjustmentGroups()");
		
		try {
			AdjustmentsResponses adjustmentGroups = iGenericResponseService.getAdjustmentGroups();
			
			logger.debug("getAdjustmentGroups() :", adjustmentGroups.toString());
			return new ResponseEntity<AdjustmentsResponses>(adjustmentGroups, HttpStatus.OK);
			
		} catch (GenericException e) {
			logger.error("getAdjustmentGroups() exception occured : "
					+" - " + e.getMessage());
			
			throw e; 
		}
	}
	
	/**
	 * Get all reason codes for a given group
	 * @return a list of reason codes
	 * @throws GenericException
	 */
	@RequestMapping(value = "/adjreasons/{groupCode}", method = RequestMethod.GET, produces = "application/json")
	public ResponseEntity<AdjustmentsResponses> getAdjustmentReasonsByGroupCode(@PathVariable("groupCode") String groupCode) throws GenericException {
		
		logger.info("getAdjustmentReasonsByGroupCode()");
		
		try {
			AdjustmentsResponses adjustmentReasons = iGenericResponseService.getAdjustmentReasonsByGroupCode(groupCode);
			
			logger.debug("getAdjustmentReasonsByGroupCode() :", adjustmentReasons.toString());
			return new ResponseEntity<AdjustmentsResponses>(adjustmentReasons, HttpStatus.OK);
			
		} catch (GenericException e) {
			logger.error("getAdjustmentReasonsByGroupCode() exception occured : "
					+" - " + e.getMessage());
			
			throw e; 
		}
	}
}
