/**
 * 
 */
package gov.va.med.fee.constants;

/**
 * @author Vamsi Krishna Gangarapu
 * Interface class for all the constants used in Claims Details Page.
 *
 */
public interface ClaimDetailsConstants {
	
	// Provider Types
	String PAY_TO_PROVIDER_TYPE = "PAY TO PROVIDER";
	String SERVICE_PROVIDER_TYPE = "SERVICE FACILITY";
	String SERVICE_PROVIDER_TYPE_W_DENT = "SERVICE LOCATION";
	String BILLING_PROVIDER_TYPE = "BILLING PROVIDER";
	String BILLING_PROVIDER_TYPE_OLD = "REMITADDR";
	String REJECTION_HISTORY_TAB = "REJECTION_APPROVAL";
	
	// Claim Types
	String DENTAL_CLAIM = "DENT";
	String PROFESSIONAL_CLAIM = "PROF";
	String INSTITUTIONAL_CLAIM = "INST";

	// Error Codes and Error Descriptions for all Claim Details API's
	String INVALID_REQUEST = "invalid_input_error";
	String DATABASE_CONNECTION_FAILURE = "database_connection_error";
	String DATA_ACCESS_ERROR = "data_access_error";
	String INTERNAL_SERVER_ERROR = "internal_server_error";
	String BAD_REQUEST = "bad_request";
	String NOT_FOUND = "not_found_error";
	String NO_CONTENT = "no_content_error";
	String CLAIM_NOT_FOUND = "claim_not_found";
	String VETERAN_INFO_NOT_FOUND = "veteran_info_not_found";
	String BILLING_PROVIDER_INFO_NOT_FOUND = "billing_provider_info_not_found";
	String SERVICE_PROVIDER_INFO_NOT_FOUND = "service_provider_info_not_found";
	String PAY_TO_PROVIDER_INFO_NOT_FOUND = "pay_to_provider_info_not_found";
	
	// Added for handling various claim status codes - Muneshwar Baiah   
	// Claim Status Codes 
	String AWAITING_STATUS_CODE = "ESTABLISH";
	String INPROCESS_STATUS_CODE = "INPROCESS";
	String AGED_STATUS_CODE = "AGED";
	String PAYERROR_STATUS_CODE = "PAYERROR";
	String REJECTED_STATUS_CODE = "REJECTED";
	String COMPLETE_STATUS_CODE = "COMPLETE";
	String REVERSED_STATUS_CODE = "REVERSED";
}
