package gov.va.med.fee.configuration.spring;

import javax.servlet.Filter;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.web.WebApplicationInitializer;
import org.springframework.web.servlet.support.AbstractAnnotationConfigDispatcherServletInitializer;

import gov.va.med.fee.configuration.AppConfig;
import gov.va.med.fee.filter.CORSFilter;

/**
 * @author Eyuel Taddese
 *
 */

public class SpringAppInitializer extends AbstractAnnotationConfigDispatcherServletInitializer implements WebApplicationInitializer{

	@Override
	protected Class<?>[] getRootConfigClasses() {
		// TODO Auto-generated method stub
		return new Class<?>[] {AppConfig.class};
	}

	// TBD - if the app does not work we need to add the WebMvcConfiguration
	@Override
	protected Class<?>[] getServletConfigClasses() {
		// TODO Auto-generated method stub
		return new Class<?>[] {SpringMvcConfig.class};
	}

	@Override
	protected String[] getServletMappings() {
		// TODO Auto-generated method stub
		return new String[] {"/"};
	}
	
	@Override
	protected Filter[] getServletFilters() {
		return new Filter[] { new CORSFilter() };
	}
	
	
	@Autowired
	private Environment env;
	
/*	@Override
	public void onStartup(ServletContext servletContext) throws ServletException {
		super.onStartup(servletContext);
		servletContext.setInitParameter("spring.profiles.active", env.getProperty("spring.profiles.active"));
		System.out.println("Development profile has been set"+env.getProperty("spring.profiles.active"));
	}*/
}
