package gov.va.med.fee.configuration;

import org.springframework.aop.aspectj.annotation.AnnotationAwareAspectJAutoProxyCreator;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.CacheManager;
import org.springframework.cache.annotation.EnableCaching;
import org.springframework.cache.concurrent.ConcurrentMapCacheManager;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.EnableAspectJAutoProxy;
import org.springframework.context.annotation.FilterType;
import org.springframework.context.annotation.Profile;
import org.springframework.context.annotation.PropertySource;
import org.springframework.context.annotation.PropertySources;
import org.springframework.context.support.PropertySourcesPlaceholderConfigurer;
import org.springframework.core.env.Environment;


/**
 * @author Eyuel Taddese
 *
 */

@Configuration
public class AppConfig {
	
	@Configuration
	@Profile("default")
	@ComponentScan(basePackages="gov.va.med",excludeFilters = @ComponentScan.Filter(type = FilterType.REGEX,pattern = "gov.va.med.fee.configuration.spring"))
	@PropertySources( {@PropertySource("classpath:application.properties"),@PropertySource("classpath:oauth.properties"),@PropertySource("classpath:ValidationMessages.properties")})
	@EnableCaching
	@EnableAspectJAutoProxy
	static class Defaults {
		
	}
	
	@Configuration
	@Profile("dev")
	@ComponentScan(basePackages="gov.va.med",excludeFilters = @ComponentScan.Filter(type = FilterType.REGEX,pattern = "gov.va.med.fee.configuration.spring"))
	@PropertySources( {@PropertySource("classpath:development.properties"),@PropertySource("classpath:oauth.properties"),@PropertySource("classpath:ValidationMessages.properties"),@PropertySource("classpath:port.properties")})
	@EnableCaching
	@EnableAspectJAutoProxy(proxyTargetClass=true)
	static class Development {
		
	}
	
	@Configuration
	@Profile("qa")
	@PropertySources( {@PropertySource("classpath:qa.properties"),@PropertySource("classpath:oauth.properties"),@PropertySource("classpath:ValidationMessages.properties"),@PropertySource("classpath:port.properties")})
	@ComponentScan(basePackages="gov.va.med")
	@EnableCaching
	@EnableAspectJAutoProxy(proxyTargetClass=true)
	static class QA {
		
	}
	
	@Configuration
	@Profile("production")
	@PropertySources( {@PropertySource("classpath:prod.properties"),@PropertySource("classpath:oauth.properties")})
	@EnableCaching
	@EnableAspectJAutoProxy
	static class Production {
		
	}
	
/*	@Autowired
	private Environment env;*/

	@Bean
	public static PropertySourcesPlaceholderConfigurer placeholderCOnfigurer(){
		return new PropertySourcesPlaceholderConfigurer();
	}

	@Bean
	public CacheManager cacheManager() {
		return new ConcurrentMapCacheManager();
	}
	
	@Bean
	public AnnotationAwareAspectJAutoProxyCreator annotationAwareAspectJAutoProxy() {
		return new AnnotationAwareAspectJAutoProxyCreator();
	}
}
