package gov.va.cpss.sftp;

import java.io.File;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Scanner;

import org.apache.log4j.Logger;
import org.apache.sshd.common.NamedFactory;
import org.apache.sshd.common.file.virtualfs.VirtualFileSystemFactory;
import org.apache.sshd.server.Command;
import org.apache.sshd.server.SshServer;
import org.apache.sshd.server.auth.password.PasswordAuthenticator;
import org.apache.sshd.server.auth.pubkey.AcceptAllPublickeyAuthenticator;
import org.apache.sshd.server.keyprovider.SimpleGeneratorHostKeyProvider;
import org.apache.sshd.server.scp.ScpCommandFactory;
import org.apache.sshd.server.session.ServerSession;
import org.apache.sshd.server.subsystem.sftp.SftpSubsystemFactory;
import org.springframework.test.context.ContextConfiguration;

/**
 * Mock Test SFTP Server.
 * 
 * @author DNS  
 */
@ContextConfiguration(locations = { "/test-context.xml" })
public class MockSftpServer {

	private static final Logger logger = Logger.getLogger(MockSftpServer.class.getCanonicalName());

	private static final String LOCAL_SFTP_SERVER_ROOT = "C:\\Temp\\SFTPROOT";

	private SshServer sshd;

	public void start(String userInput) throws Exception {

		System.out.println("Starting Mock SFTP Server...");

		sshd = SshServer.setUpDefaultServer();
		sshd.setPort(22);
		sshd.setKeyPairProvider(new SimpleGeneratorHostKeyProvider(new File("hostkey.ser")));
		if(userInput.equals("5"))
		{
			sshd.setPublickeyAuthenticator(AcceptAllPublickeyAuthenticator.INSTANCE);
		}
		if(userInput.equals("4"))
		{
			sshd.setPasswordAuthenticator(new PasswordAuthenticator() {
				public boolean authenticate(String username, String password, ServerSession session) {
					logger.info("SFTP Detected Login: " + username);
					return true;
				}
			});
		}

		ScpCommandFactory myCommandFactory = new ScpCommandFactory() {
			public Command createCommand(String command) {
				logger.info("SFTP Processing Command: " + command);
				return null;
			}
		};
		sshd.setCommandFactory(myCommandFactory);

		sshd.setSubsystemFactories(Arrays.<NamedFactory<Command>> asList(new SftpSubsystemFactory()));

		sshd.setFileSystemFactory(new VirtualFileSystemFactory(Paths.get(LOCAL_SFTP_SERVER_ROOT)));

		sshd.start();
	}

	public void stop() throws Exception {
		System.out.println("Stopping Mock SFTP Server...");
		sshd.stop();
	}

	public static void main(String args[]) {

		MockSftpServer mockServer = new MockSftpServer();

		try {
		
			String userInput =	pickLogin();
			
			mockServer.start(userInput);

			mockServer.run();

			mockServer.stop();

		} catch (Exception e) {
			System.err.println("Unexpected exception running Mock SFTP Server: " + e.getMessage());
		}
	}

	private final void run() {
		String input = "0";
		Scanner keyboard = new Scanner(System.in);
		while (!input.equals("1")) {
			System.out.println("input = " + input);
			System.out.println("Press 1 to stop");
			try {
				input = keyboard.next();
			} catch (Exception e) {
				System.err.println("Invalid Input Detected");
				input = "0";
			}
		}
		keyboard.close();
		System.out.println("Shutting down ftp server.");
	}
	
	private static String pickLogin()
	{
		String userInput ="3";
		Scanner keyboard = new Scanner(System.in);
		while (userInput.equals("3")) {
		try {
			System.out.println("Please Enter 4 for password Authentication or Enter 5 for Private Key Authentication");
			userInput = keyboard.next();
			System.out.println("User Input is: " + userInput);
		} catch (Exception e) {
			System.err.println("Invalid Input Detected Password Will Be Used");
			userInput = "4";
		}
		}
		
		return userInput;
	}

}
