package gov.va.cpss.service;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNotNull;
import static org.junit.Assert.assertNull;
import static org.junit.Assert.assertTrue;
import static org.junit.Assume.assumeTrue;

import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;

import gov.va.cpss.model.icn.VistaAccount;

/** 
 * Unit test for VistaAccountService class.
 * 
 *
 */
@RunWith(SpringJUnit4ClassRunner.class)
@ContextConfiguration(locations = { "/test-context-memory.xml", "/cpss-context.xml" })
public class VistaAccountServiceTest {

	@Value("${run.integration.test:false}")
	private Boolean runIntegrationTest;

	@Autowired
	private VistaAccountService vistaAccountService;

	/**
	 * Only run these tests if property is set to run integration test.
	 */
	@Before
	public final void beforeTest() {
		assumeTrue(runIntegrationTest);
	}

	@Test
	public final void testRegisteredAccount() {
		assertNotNull(vistaAccountService);

		final long dfn = 8877665544L;
		final String site = "123";
		final long accountNumber = 1234;
		final String icn = "ICN1234567890";

		// Prerequisite:
		// The cbss-cbs-db-unit-test-data.sql should have inserted into CBS
		// Account (1234,
		// ICN1234567890)
		// This represents the Account/ICN pair.

		// First, make sure there is no account for this dfn/site pair.
		assertNull(vistaAccountService.getAccountRecord(dfn, site));

		// Then, register the dfn/site pair with the ICN and account number.
		VistaAccount vista = new VistaAccount(dfn, site, icn, accountNumber);
		final boolean registered = vistaAccountService.registerAccount(vista);
		assertTrue(registered);

		// Now get the account for this dfn/site pair.
		VistaAccount checkExists = vistaAccountService.getAccountRecord(dfn, site);

		// Check that the returned account values are expected values.
		assertEquals(dfn, checkExists.getDfn());
		assertEquals(site, checkExists.getStationNum());
		assertEquals(icn, checkExists.getIcn());
		assertEquals(accountNumber, checkExists.getCbssAcntId());
	}

}
