package gov.va.cpss.service;

import static org.junit.Assert.assertTrue;
import static org.junit.Assert.fail;

import java.util.Iterator;

import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;

import com.dumbster.smtp.SmtpMessage;

import gov.va.cpss.email.MockEmailServer;

/**
 * Integration Unit Tests to test success and failure cases of EmailService
 * 
 * @author DNS   
 */
@RunWith(SpringJUnit4ClassRunner.class)
@ContextConfiguration(locations = { "/test-context.xml", "/test-email-server.xml", "/cpss-email.xml" })
public class EmailServiceIT {

	@Autowired
	private EmailService emailService;
	
	@Autowired
	private MockEmailServer<SmtpMessage> mockEmailServer;

	@Test
	public final void testDumbsterEmail() {

		try {
			emailService.cpssReadyToSendEmail("PII               ", "CBSS Subject!",
					"CBSS message  --- This is actual message");
		} catch (Exception e) {
			e.printStackTrace();
			fail("Unexpected exception: " + e);
		}

		assertTrue(mockEmailServer.getReceivedEmailSize() == 1);
		Iterator<SmtpMessage> emailIter = mockEmailServer.getReceivedEmail();
		SmtpMessage email = emailIter.next();
		// Set Subject: header field
		assertTrue(email.getHeaderValue("Subject").equals("CBSS Subject!"));
		// Now set the actual message
		assertTrue(email.getBody().equals("CBSS message  --- This is actual message"));
	}

}
