package gov.va.cpss.job.loadbill;

import static gov.va.cpss.job.CbssJobProcessingConstants.FILE_OPEN_ERROR_STATUS;

import java.util.List;
import java.util.Map;

import org.springframework.core.io.Resource;

import gov.va.cpss.model.loadbill.LoadBillDetail;
import gov.va.cpss.model.loadbill.LoadBillHeader;

/**
 * Item reader used only for Load Bill integration tests. This class overrides the doOpen
 * method of LoadBillSftpLineItemReader to bypass the SFTP server.
 * 
 * @author Andrew Vance
 */
public final class LoadBillFlatLineItemReader<T> extends LoadBillSftpLineItemReader<Map.Entry<LoadBillHeader, List<LoadBillDetail>>>{
	
	@Override
	protected void doOpen() throws Exception {
		opened = false;
		
		try {
			if (resource.getFilename() != null) {
				final Long expectedByteCount = resource.getFile().length();

				queueBuilderThread = getQueueBuilderThread(expectedByteCount, resource.getInputStream(), dataQueue);
				if(queueBuilderThread != null) {
					queueBuilderThread.start();
					opened=true;
				} else {
					setFailureStatusAndMessage(FILE_OPEN_ERROR_STATUS,
							"Unable to open file because failed to obtain data stream processing thread");
				}
			} else {
				setFailureStatusAndMessage(FILE_OPEN_ERROR_STATUS,
						"Unable to open file because failed file size request");
			}
		} catch (Exception e) {
			StringBuilder error = new StringBuilder();
			error.append("Unable to open for read because of ");
			error.append(e.getClass().getSimpleName());
			error.append("\nMessage: ");
			error.append(e.getMessage());

			setFailureStatusAndMessage(FILE_OPEN_ERROR_STATUS, error.toString());
		}
	}
	
	@Override
	public void setResource(Resource resource) {
		this.resource = resource;
	}

}