package gov.va.cpss.job;

import gov.va.cpss.model.BatchJob;
import gov.va.cpss.model.BatchRun;

/**
 * Test Wrapper for UpdatePrintAckJob
 * 
 * @author Brad Pickle
 *
 */
public class TestUpdatePrintAckJob extends UpdatePrintAckJob {
	
	private int batchRunId;

	public int getBatchRunId() {
		return batchRunId;
	}

	/**
	 * Sets up the BachJob and BatchRun context then runs the UpdatePrintAckJob.
	 * 
	 * @return Boolean value indicating if successful or not.
	 */
	public boolean testJob() {

		boolean successful = false;

		resetMessages();
		BatchJob bj = batchService.getBatchJobByName(name);
		BatchRun bR = batchService.startRun(bj.getId());

		if (bR != null) {
			batchRunId = bR.getId();

			jobLogger.info("Job " + name + " Started: " + bR.getStartDate());

			if (getJob() == null) {
				jobLogger.error("Job batch is null");
				errorRun(bR);
			} else if (runJob(bR, getJob())) {
				completeRun(bR);
				successful = true;
			} else {
				errorRun(bR);
			}
			
			jobLogger.info(buildEmailMessage(bj, bR));

		} else {
			final String errorMessage = "Problem Starting Job " + name;
			jobLogger.error(errorMessage);
		}
		
		return successful;
	}

}
