package gov.va.cpss.jasper;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/**
 * Factory class test
 * 
 *
 */
public class TestPdfSiteStatementCollectionBeanFactory {

	public static List<PdfSiteStatementCollectionBean> create() {

		PdfSiteStatementCollectionBean siteStatementCollection = new PdfSiteStatementCollectionBean();

		PdfSiteStatementBean siteStatement1 = new PdfSiteStatementBean();
		siteStatement1.setFacility("CHEYENNE, WYOMING. VA MEDICAL FACILITY # 442");
		siteStatement1.setRecords(Arrays.asList(
				new PdfSiteStatementEntryBean("OUTPATIENT CARE VISIT DATE: 08/08/2015", "50.00", "442-K1017TY"),
				new PdfSiteStatementEntryBean(
						"COPAY RX#8765432 FILL DATE: 08/10/2015<br/>DRUG: INSULIN,ASPART,HUMAN 100 UNIT/ML INJ<br/>DAYS:90 QTY:l2 PHY:XABCRFI,XXZALA D  CHG:$24.00",
						"24.00", "442-K101QJJ"),
				new PdfSiteStatementEntryBean("", "", ""),
				new PdfSiteStatementEntryBean("PAYMENT POSTED ON 08/13/2015 (#35467310)", "20.00-", ""),
				new PdfSiteStatementEntryBean("INTEREST/ADM. CHARGE (lnt:0.07 Adm:l.87 Other:0.00)", "1.94", ""),
				new PdfSiteStatementEntryBean("CHARGE SUSPENDED 08/24/2015 (#47365737)", "[9.00]", "442-K30EAAA"),
				new PdfSiteStatementEntryBean("CHARGE SUSPENDED 08/24/2015 (#77365777)", "[6.00]", "442-K1034RR")));
		siteStatement1.setTotalLabel("FACILITY # 442 TOTAL >>>");
		siteStatement1.setTotal("75.94");

		PdfSiteStatementBean siteStatement2 = new PdfSiteStatementBean();
		siteStatement2.setFacility("BECKLEY, WEST VIRGINIA. VA MEDICAL FACILITY # 517");
		siteStatement2.setRecords(Arrays.asList(
				new PdfSiteStatementEntryBean(
						"COPAY RX#123456 FILL DATE: 08/06/2015<br/>DRUG:METHADONE l0MG TAB DAYS:30 QTY:60<br/>PHY:XXQAD,QRSAXXAN MIXXN  CHG:$8.00",
						"8.00", "517-K2028PP"),
				new PdfSiteStatementEntryBean("INTEREST/ADM. CHARGE (lnt:0.15 Adm:l.87 Other:0.00)", "2.02", ""),
				new PdfSiteStatementEntryBean("CHARGE SUSPENDED ON 08/12/2015 (#45365436)", "[78.45]", "517-K202IUK")));
		siteStatement2.setTotalLabel("FACILITY # 517 TOTAL >>>");
		siteStatement2.setTotal("10.02");

		PdfSiteStatementBean siteStatement3 = new PdfSiteStatementBean();
		siteStatement3.setFacility("LITTLE ROCK, ARKANSAS. VA MEDICAL FACILITY # 598");
		siteStatement3.setRecords(Arrays.asList(new PdfSiteStatementEntryBean(
				"COPAY RX#2111105X FILL DATE: 08/23/2015<br/>DRUG:GLIPIZIDE l0MG TAB DAYS:90 QTY:l80<br/>PHY:XXESB,XXXRROLL D  CHG:$27.00",
				"27.00", "598-K191REW")));
		siteStatement3.setTotalLabel("FACILITY # 598 TOTAL >>>");
		siteStatement3.setTotal("27.00");

		PdfSiteStatementBean siteStatement4 = new PdfSiteStatementBean();
		siteStatement4.setFacility("NORTHAMPTON, MASSACHUSETTS. VA MEDICAL FACILITY # 631");
		siteStatement4.setRecords(Arrays.asList(
				new PdfSiteStatementEntryBean("OUTPATIENT CARE VISIT DATE: 08/08/2015", "4.00", "631-K103TY6"),
				new PdfSiteStatementEntryBean(
						"COPAY RX#211588Q9A FILL DATE: 08/20/2015<br/>DRUG:ATENOLOL 25MG TAB DAYS:90 QTY:90<br/>PHY:WXXNQR,XCNN NP CHG:$11.00",
						"11.00", "631-K103YHG"),
				new PdfSiteStatementEntryBean("", "", ""),
				new PdfSiteStatementEntryBean("PAYMENT POSTED ON 08/08/2015 (#35467111)", "24.00-", ""),
				new PdfSiteStatementEntryBean("PAYMENT POSTED ON 08/10/2015 (#35467121)", "36.00-", ""),
				new PdfSiteStatementEntryBean("PAYMENT POSTED ON 08/12/2015 (#35467132)", "35.00-", ""),
				new PdfSiteStatementEntryBean("PAYMENT POSTED ON 08/14/2015 (#35467243)", "4.00-", ""),
				new PdfSiteStatementEntryBean("", "", ""),
				new PdfSiteStatementEntryBean("CHARGE SUSPENDED 08/15/2015 (#45777436)", "[7.00]", "631-K177YHX"),
				new PdfSiteStatementEntryBean("CHARGE SUSPENDED 08/16/2015 (#45365777)", "[8.00]", "631-K422ZQX")));
		siteStatement4.setTotalLabel("FACILITY # 631 TOTAL >>>");
		siteStatement4.setTotal("15.00");

		PdfSiteStatementBean siteStatement5 = new PdfSiteStatementBean();
		siteStatement5.setFacility("ANN ARBOR, MICHIGAN. VA MEDICAL FACILITY # 506");
		siteStatement5.setRecords(Arrays.asList(new PdfSiteStatementEntryBean("", "", ""),
				new PdfSiteStatementEntryBean(
						"COPAY RX#453588Q8Y FILL DATE: 08/14/2015<br/>DRUG:ATENOLOL 15MG TAB DAYS:30 QTY:30<br/>PHY:AXXNQRYYUT,JOOEEY NP CHG:$11.00",
						"11.00", "506-K133ZRA"),
				new PdfSiteStatementEntryBean("", "", ""),
				new PdfSiteStatementEntryBean("PAYMENT POSTED ON 08/24/2015 (#35463434)", "100.00-", ""),
				new PdfSiteStatementEntryBean("", "", ""),
				new PdfSiteStatementEntryBean("CHARGE SUSPENDED 08/18/2015 (#45365777)", "[89.00]", "506-K134APP")));
		siteStatement5.setTotalLabel("FACILITY # 506 TOTAL >>>");
		siteStatement5.setTotal("11.00");

		siteStatementCollection.setSiteStatementL(
				Arrays.asList(siteStatement1, siteStatement2, siteStatement3, siteStatement4, siteStatement5));
		return Arrays.asList(siteStatementCollection);
	}

	public static List<PdfSiteStatementCollectionBean> createSimple() {

		PdfSiteStatementCollectionBean siteStatementCollection = new PdfSiteStatementCollectionBean();

		PdfSiteStatementBean siteStatement1 = new PdfSiteStatementBean();
		siteStatement1.setFacility("CHEYENNE, WYOMING. VA MEDICAL FACILITY # 442");
		siteStatement1.setRecords(Arrays.asList(
				new PdfSiteStatementEntryBean("OUTPATIENT CARE <br/> HELLO <br/> WORLD", "50.00", "442-K1017TY"),
				new PdfSiteStatementEntryBean("OUTPATIENT CARE 2<br/> HELLO <br/> WORLD", "50.00", "442-K1017TY")));
		siteStatement1.setTotalLabel("FACILITY # 442 TOTAL >>>");
		siteStatement1.setTotal("75.94");

		siteStatementCollection.setSiteStatementL(Arrays.asList(siteStatement1));
		return Arrays.asList(siteStatementCollection);
	}

	public static List<PdfSiteStatementCollectionBean> createLong() {

		PdfSiteStatementCollectionBean siteStatementCollection = new PdfSiteStatementCollectionBean();

		PdfSiteStatementBean siteStatement1 = new PdfSiteStatementBean();
		siteStatement1.setFacility("CHEYENNE, WYOMING. VA MEDICAL FACILITY # 442");

		siteStatement1.setRecords(Arrays.asList(
				new PdfSiteStatementEntryBean("OUTPATIENT CARE VISIT DATE: 08/08/2015", "50.00", "442-K1017TY"),
				new PdfSiteStatementEntryBean(
						"COPAY RX#8765432 FILL DATE: 08/10/2015<br/>DRUG: INSULIN,ASPART,HUMAN 100 UNIT/ML INJ<br/>DAYS:90 QTY:l2 PHY:XABCRFI,XXZALA D  CHG:$24.00",
						"24.00", "442-K101QJJ"),
				new PdfSiteStatementEntryBean("", "", ""),
				new PdfSiteStatementEntryBean("PAYMENT POSTED ON 08/13/2015 (#35467310)", "20.00-", ""),
				new PdfSiteStatementEntryBean("INTEREST/ADM. CHARGE (lnt:0.07 Adm:l.87 Other:0.00)", "1.94", ""),
				new PdfSiteStatementEntryBean("CHARGE SUSPENDED 08/24/2015 (#47365737)", "[9.00]", "442-K30EAAA"),
				new PdfSiteStatementEntryBean("CHARGE SUSPENDED 08/24/2015 (#77365777)", "[6.00]", "442-K1034RR"),

				new PdfSiteStatementEntryBean(
						"COPAY RX#123456 FILL DATE: 08/06/2015<br/>DRUG:METHADONE l0MG TAB DAYS:30 QTY:60<br/>PHY:XXQAD,QRSAXXAN MIXXN  CHG:$8.00",
						"8.00", "517-K2028PP"),
				new PdfSiteStatementEntryBean("INTEREST/ADM. CHARGE (lnt:0.15 Adm:l.87 Other:0.00)", "2.02", ""),
				new PdfSiteStatementEntryBean("CHARGE SUSPENDED ON 08/12/2015 (#45365436)", "[78.45]", "517-K202IUK"),

				new PdfSiteStatementEntryBean(
						"COPAY RX#2111105X FILL DATE: 08/23/2015<br/>DRUG:GLIPIZIDE l0MG TAB DAYS:90 QTY:l80<br/>PHY:XXESB,XXXRROLL D  CHG:$27.00",
						"27.00", "598-K191REW"),

				new PdfSiteStatementEntryBean("OUTPATIENT CARE VISIT DATE: 08/08/2015", "4.00", "631-K103TY6"),
				new PdfSiteStatementEntryBean(
						"COPAY RX#211588Q9A FILL DATE: 08/20/2015<br/>DRUG:ATENOLOL 25MG TAB DAYS:90 QTY:90<br/>PHY:WXXNQR,XCNN NP CHG:$11.00",
						"11.00", "631-K103YHG"),
				new PdfSiteStatementEntryBean("", "", ""),
				new PdfSiteStatementEntryBean("PAYMENT POSTED ON 08/08/2015 (#35467111)", "24.00-", ""),
				new PdfSiteStatementEntryBean("PAYMENT POSTED ON 08/10/2015 (#35467121)", "36.00-", ""),
				new PdfSiteStatementEntryBean("PAYMENT POSTED ON 08/12/2015 (#35467132)", "35.00-", ""),
				new PdfSiteStatementEntryBean("PAYMENT POSTED ON 08/14/2015 (#35467243)", "4.00-", ""),
				new PdfSiteStatementEntryBean("", "", ""),
				new PdfSiteStatementEntryBean("CHARGE SUSPENDED 08/15/2015 (#45777436)", "[7.00]", "631-K177YHX"),
				new PdfSiteStatementEntryBean("CHARGE SUSPENDED 08/16/2015 (#45365777)", "[8.00]", "631-K422ZQX"),

				new PdfSiteStatementEntryBean("", "", ""),
				new PdfSiteStatementEntryBean(
						"COPAY RX#453588Q8Y FILL DATE: 08/14/2015<br/>DRUG:ATENOLOL 15MG TAB DAYS:30 QTY:30<br/>PHY:AXXNQRYYUT,JOOEEY NP CHG:$11.00",
						"11.00", "506-K133ZRA"),
				new PdfSiteStatementEntryBean("", "", ""),
				new PdfSiteStatementEntryBean("PAYMENT POSTED ON 08/24/2015 (#35463434)", "100.00-", ""),
				new PdfSiteStatementEntryBean("", "", ""),
				new PdfSiteStatementEntryBean("CHARGE SUSPENDED 08/18/2015 (#45365777)", "[89.00]", "506-K134APP"),
				
				
				
				
				
				new PdfSiteStatementEntryBean("OUTPATIENT CARE VISIT DATE: 08/08/2015", "50.00", "442-K1017TY"),
				new PdfSiteStatementEntryBean(
						"COPAY RX#8765432 FILL DATE: 08/10/2015<br/>DRUG: INSULIN,ASPART,HUMAN 100 UNIT/ML INJ<br/>DAYS:90 QTY:l2 PHY:XABCRFI,XXZALA D  CHG:$24.00",
						"24.00", "442-K101QJJ"),
				new PdfSiteStatementEntryBean("", "", ""),
				new PdfSiteStatementEntryBean("PAYMENT POSTED ON 08/13/2015 (#35467310)", "20.00-", ""),
				new PdfSiteStatementEntryBean("INTEREST/ADM. CHARGE (lnt:0.07 Adm:l.87 Other:0.00)", "1.94", ""),
				new PdfSiteStatementEntryBean("CHARGE SUSPENDED 08/24/2015 (#47365737)", "[9.00]", "442-K30EAAA"),
				new PdfSiteStatementEntryBean("CHARGE SUSPENDED 08/24/2015 (#77365777)", "[6.00]", "442-K1034RR"),

				new PdfSiteStatementEntryBean(
						"COPAY RX#123456 FILL DATE: 08/06/2015<br/>DRUG:METHADONE l0MG TAB DAYS:30 QTY:60<br/>PHY:XXQAD,QRSAXXAN MIXXN  CHG:$8.00",
						"8.00", "517-K2028PP"),
				new PdfSiteStatementEntryBean("INTEREST/ADM. CHARGE (lnt:0.15 Adm:l.87 Other:0.00)", "2.02", ""),
				new PdfSiteStatementEntryBean("CHARGE SUSPENDED ON 08/12/2015 (#45365436)", "[78.45]", "517-K202IUK"),

				new PdfSiteStatementEntryBean(
						"COPAY RX#2111105X FILL DATE: 08/23/2015<br/>DRUG:GLIPIZIDE l0MG TAB DAYS:90 QTY:l80<br/>PHY:XXESB,XXXRROLL D  CHG:$27.00",
						"27.00", "598-K191REW"),

				new PdfSiteStatementEntryBean("OUTPATIENT CARE VISIT DATE: 08/08/2015", "4.00", "631-K103TY6"),
				new PdfSiteStatementEntryBean(
						"COPAY RX#211588Q9A FILL DATE: 08/20/2015<br/>DRUG:ATENOLOL 25MG TAB DAYS:90 QTY:90<br/>PHY:WXXNQR,XCNN NP CHG:$11.00",
						"11.00", "631-K103YHG"),
				new PdfSiteStatementEntryBean("", "", ""),
				new PdfSiteStatementEntryBean("PAYMENT POSTED ON 08/08/2015 (#35467111)", "24.00-", ""),
				new PdfSiteStatementEntryBean("PAYMENT POSTED ON 08/10/2015 (#35467121)", "36.00-", ""),
				new PdfSiteStatementEntryBean("PAYMENT POSTED ON 08/12/2015 (#35467132)", "35.00-", ""),
				new PdfSiteStatementEntryBean("PAYMENT POSTED ON 08/14/2015 (#35467243)", "4.00-", ""),
				new PdfSiteStatementEntryBean("", "", ""),
				new PdfSiteStatementEntryBean("CHARGE SUSPENDED 08/15/2015 (#45777436)", "[7.00]", "631-K177YHX"),
				new PdfSiteStatementEntryBean("CHARGE SUSPENDED 08/16/2015 (#45365777)", "[8.00]", "631-K422ZQX"),

				new PdfSiteStatementEntryBean("", "", ""),
				new PdfSiteStatementEntryBean(
						"COPAY RX#453588Q8Y FILL DATE: 08/14/2015<br/>DRUG:ATENOLOL 15MG TAB DAYS:30 QTY:30<br/>PHY:AXXNQRYYUT,JOOEEY NP CHG:$11.00",
						"11.00", "506-K133ZRA"),
				new PdfSiteStatementEntryBean("", "", ""),
				new PdfSiteStatementEntryBean("PAYMENT POSTED ON 08/24/2015 (#35463434)", "100.00-", ""),
				new PdfSiteStatementEntryBean("", "", ""),
				new PdfSiteStatementEntryBean("CHARGE SUSPENDED 08/18/2015 (#45365777)", "[89.00]", "506-K134APP"),
				
				
				
				
				
				
				
				new PdfSiteStatementEntryBean("OUTPATIENT CARE VISIT DATE: 08/08/2015", "50.00", "442-K1017TY"),
				new PdfSiteStatementEntryBean(
						"COPAY RX#8765432 FILL DATE: 08/10/2015<br/>DRUG: INSULIN,ASPART,HUMAN 100 UNIT/ML INJ<br/>DAYS:90 QTY:l2 PHY:XABCRFI,XXZALA D  CHG:$24.00",
						"24.00", "442-K101QJJ"),
				new PdfSiteStatementEntryBean("", "", ""),
				new PdfSiteStatementEntryBean("PAYMENT POSTED ON 08/13/2015 (#35467310)", "20.00-", ""),
				new PdfSiteStatementEntryBean("INTEREST/ADM. CHARGE (lnt:0.07 Adm:l.87 Other:0.00)", "1.94", ""),
				new PdfSiteStatementEntryBean("CHARGE SUSPENDED 08/24/2015 (#47365737)", "[9.00]", "442-K30EAAA"),
				new PdfSiteStatementEntryBean("CHARGE SUSPENDED 08/24/2015 (#77365777)", "[6.00]", "442-K1034RR"),

				new PdfSiteStatementEntryBean(
						"COPAY RX#123456 FILL DATE: 08/06/2015<br/>DRUG:METHADONE l0MG TAB DAYS:30 QTY:60<br/>PHY:XXQAD,QRSAXXAN MIXXN  CHG:$8.00",
						"8.00", "517-K2028PP"),
				new PdfSiteStatementEntryBean("INTEREST/ADM. CHARGE (lnt:0.15 Adm:l.87 Other:0.00)", "2.02", ""),
				new PdfSiteStatementEntryBean("CHARGE SUSPENDED ON 08/12/2015 (#45365436)", "[78.45]", "517-K202IUK"),

				new PdfSiteStatementEntryBean(
						"COPAY RX#2111105X FILL DATE: 08/23/2015<br/>DRUG:GLIPIZIDE l0MG TAB DAYS:90 QTY:l80<br/>PHY:XXESB,XXXRROLL D  CHG:$27.00",
						"27.00", "598-K191REW"),

				new PdfSiteStatementEntryBean("OUTPATIENT CARE VISIT DATE: 08/08/2015", "4.00", "631-K103TY6"),
				new PdfSiteStatementEntryBean(
						"COPAY RX#211588Q9A FILL DATE: 08/20/2015<br/>DRUG:ATENOLOL 25MG TAB DAYS:90 QTY:90<br/>PHY:WXXNQR,XCNN NP CHG:$11.00",
						"11.00", "631-K103YHG"),
				new PdfSiteStatementEntryBean("", "", ""),
				new PdfSiteStatementEntryBean("PAYMENT POSTED ON 08/08/2015 (#35467111)", "24.00-", ""),
				new PdfSiteStatementEntryBean("PAYMENT POSTED ON 08/10/2015 (#35467121)", "36.00-", ""),
				new PdfSiteStatementEntryBean("PAYMENT POSTED ON 08/12/2015 (#35467132)", "35.00-", ""),
				new PdfSiteStatementEntryBean("PAYMENT POSTED ON 08/14/2015 (#35467243)", "4.00-", ""),
				new PdfSiteStatementEntryBean("", "", ""),
				new PdfSiteStatementEntryBean("CHARGE SUSPENDED 08/15/2015 (#45777436)", "[7.00]", "631-K177YHX"),
				new PdfSiteStatementEntryBean("CHARGE SUSPENDED 08/16/2015 (#45365777)", "[8.00]", "631-K422ZQX"),

				new PdfSiteStatementEntryBean("", "", ""),
				new PdfSiteStatementEntryBean(
						"COPAY RX#453588Q8Y FILL DATE: 08/14/2015<br/>DRUG:ATENOLOL 15MG TAB DAYS:30 QTY:30<br/>PHY:AXXNQRYYUT,JOOEEY NP CHG:$11.00",
						"11.00", "506-K133ZRA"),
				new PdfSiteStatementEntryBean("", "", ""),
				new PdfSiteStatementEntryBean("PAYMENT POSTED ON 08/24/2015 (#35463434)", "100.00-", ""),
				new PdfSiteStatementEntryBean("", "", ""),
				new PdfSiteStatementEntryBean("CHARGE SUSPENDED 08/18/2015 (#45365777)", "[89.00]", "506-K134APP")
				
				
				
				
				
				
				));
		siteStatement1.setTotalLabel("FACILITY # 442 TOTAL >>>");
		siteStatement1.setTotal("11.00");

		siteStatementCollection.setSiteStatementL(Arrays.asList(siteStatement1));
		return Arrays.asList(siteStatementCollection);
	}
	
	public static List<PdfSiteStatementCollectionBean> createLong2() {

		PdfSiteStatementCollectionBean siteStatementCollection = new PdfSiteStatementCollectionBean();

		PdfSiteStatementBean siteStatement1 = new PdfSiteStatementBean();
		siteStatement1.setFacility("CHEYENNE, WYOMING. VA MEDICAL FACILITY # 442");
		siteStatement1.setRecords(Arrays.asList(
				new PdfSiteStatementEntryBean("OUTPATIENT CARE <br/> HELLO <br/> WORLD", "50.00", "442-K1017TY"),
				new PdfSiteStatementEntryBean("OUTPATIENT CARE 2<br/> HELLO <br/> WORLD", "50.00", "442-K1017TY")));
		siteStatement1.setTotalLabel("FACILITY # 442 TOTAL >>>");
		siteStatement1.setTotal("75.94");

		siteStatementCollection.setSiteStatementL(Arrays.asList(siteStatement1));
		return Arrays.asList(siteStatementCollection);
	}
	
	public static List<PdfSiteStatementCollectionBean> create2() {

		PdfSiteStatementCollectionBean siteStatementCollection = new PdfSiteStatementCollectionBean();

		PdfSiteStatementBean siteStatement1 = new PdfSiteStatementBean();
		siteStatement1.setFacility("CHEYENNE, WYOMING. VA MEDICAL FACILITY # 442");
		siteStatement1.setRecords(new ArrayList<>(Arrays.asList(
				new PdfSiteStatementEntryBean("OUTPATIENT CARE VISIT DATE: 08/08/2015", "50.00", "442-K1017TY"),
				new PdfSiteStatementEntryBean(
						"COPAY RX#8765432 FILL DATE: 08/10/2015", "24.00", "442-K101QJJ"),
				new PdfSiteStatementEntryBean("DRUG: INSULIN,ASPART,HUMAN 100 UNIT/ML INJ", "", ""),
				new PdfSiteStatementEntryBean("DAYS:90 QTY:l2 PHY:XABCRFI,XXZALA D  CHG:$24.00", "", ""),
				new PdfSiteStatementEntryBean("PAYMENT POSTED ON 08/13/2015 (#35467310)", "20.00-", ""),
				new PdfSiteStatementEntryBean("INTEREST/ADM. CHARGE (lnt:0.07 Adm:l.87 Other:0.00)", "1.94", ""),
				new PdfSiteStatementEntryBean("CHARGE SUSPENDED 08/24/2015 (#47365737)", "[9.00]", "442-K30EAAA"),
				new PdfSiteStatementEntryBean("CHARGE SUSPENDED 08/24/2015 (#77365777)", "[6.00]", "442-K1034RR"))));
		siteStatement1.setTotalLabel("FACILITY # 442 TOTAL >>>");
		siteStatement1.setTotal("75.94");

		PdfSiteStatementBean siteStatement2 = new PdfSiteStatementBean();
		siteStatement2.setFacility("BECKLEY, WEST VIRGINIA. VA MEDICAL FACILITY # 517");
		siteStatement2.setRecords(new ArrayList<>(Arrays.asList(
				new PdfSiteStatementEntryBean(
						"COPAY RX#8765432 FILL DATE: 08/10/2015", "24.00", "442-K101QJJ"),
				new PdfSiteStatementEntryBean("DRUG: INSULIN,ASPART,HUMAN 100 UNIT/ML INJ", "", ""),
				new PdfSiteStatementEntryBean("DAYS:90 QTY:l2 PHY:XABCRFI,XXZALA D  CHG:$24.00", "", ""),
				new PdfSiteStatementEntryBean("INTEREST/ADM. CHARGE (lnt:0.15 Adm:l.87 Other:0.00)", "2.02", ""),
				new PdfSiteStatementEntryBean("CHARGE SUSPENDED ON 08/12/2015 (#45365436)", "[78.45]", "517-K202IUK"))));
		siteStatement2.setTotalLabel("FACILITY # 517 TOTAL >>>");
		siteStatement2.setTotal("10.02");

		PdfSiteStatementBean siteStatement3 = new PdfSiteStatementBean();
		siteStatement3.setFacility("LITTLE ROCK, ARKANSAS. VA MEDICAL FACILITY # 598");
		siteStatement3.setRecords(new ArrayList<>(Arrays.asList(
				new PdfSiteStatementEntryBean(
						"COPAY RX#8765432 FILL DATE: 08/10/2015", "24.00", "442-K101QJJ"),
				new PdfSiteStatementEntryBean("DRUG: INSULIN,ASPART,HUMAN 100 UNIT/ML INJ", "", ""),
				new PdfSiteStatementEntryBean("DAYS:90 QTY:l2 PHY:XABCRFI,XXZALA D  CHG:$24.00", "", ""))));
		siteStatement3.setTotalLabel("FACILITY # 598 TOTAL >>>");
		siteStatement3.setTotal("27.00");

		PdfSiteStatementBean siteStatement4 = new PdfSiteStatementBean();
		siteStatement4.setFacility("NORTHAMPTON, MASSACHUSETTS. VA MEDICAL FACILITY # 631");
		siteStatement4.setRecords(new ArrayList<>(Arrays.asList(
				new PdfSiteStatementEntryBean("OUTPATIENT CARE VISIT DATE: 08/08/2015", "4.00", "631-K103TY6"),
				new PdfSiteStatementEntryBean(
						"COPAY RX#8765432 FILL DATE: 08/10/2015", "24.00", "442-K101QJJ"),
				new PdfSiteStatementEntryBean("DRUG: INSULIN,ASPART,HUMAN 100 UNIT/ML INJ", "", ""),
				new PdfSiteStatementEntryBean("DAYS:90 QTY:l2 PHY:XABCRFI,XXZALA D  CHG:$24.00", "", ""),
				new PdfSiteStatementEntryBean("PAYMENT POSTED ON 08/08/2015 (#35467111)", "24.00-", ""),
				new PdfSiteStatementEntryBean("PAYMENT POSTED ON 08/10/2015 (#35467121)", "36.00-", ""),
				new PdfSiteStatementEntryBean("PAYMENT POSTED ON 08/12/2015 (#35467132)", "35.00-", ""),
				new PdfSiteStatementEntryBean("PAYMENT POSTED ON 08/14/2015 (#35467243)", "4.00-", ""),
				new PdfSiteStatementEntryBean("CHARGE SUSPENDED 08/15/2015 (#45777436)", "[7.00]", "631-K177YHX"),
				new PdfSiteStatementEntryBean("CHARGE SUSPENDED 08/16/2015 (#45365777)", "[8.00]", "631-K422ZQX"))));
		siteStatement4.setTotalLabel("FACILITY # 631 TOTAL >>>");
		siteStatement4.setTotal("15.00");

		PdfSiteStatementBean siteStatement5 = new PdfSiteStatementBean();
		siteStatement5.setFacility("ANN ARBOR, MICHIGAN. VA MEDICAL FACILITY # 506");
		siteStatement5.setRecords(new ArrayList<>(Arrays.asList(
				new PdfSiteStatementEntryBean(
						"COPAY RX#8765432 FILL DATE: 08/10/2015", "24.00", "442-K101QJJ"),
				new PdfSiteStatementEntryBean("DRUG: INSULIN,ASPART,HUMAN 100 UNIT/ML INJ", "", ""),
				new PdfSiteStatementEntryBean("DAYS:90 QTY:l2 PHY:XABCRFI,XXZALA D  CHG:$24.00", "", ""),
				new PdfSiteStatementEntryBean("PAYMENT POSTED ON 08/24/2015 (#35463434)", "100.00-", ""),
				new PdfSiteStatementEntryBean("CHARGE SUSPENDED 08/18/2015 (#45365777)", "[89.00]", "506-K134APP"))));
		siteStatement5.setTotalLabel("FACILITY # 506 TOTAL >>>");
		siteStatement5.setTotal("11.00");
		
		
		PdfSiteStatementBean siteStatement6 = new PdfSiteStatementBean();
		siteStatement6.setFacility("BECKLEY, WEST VIRGINIA. VA MEDICAL FACILITY # 517");
		siteStatement6.setRecords(new ArrayList<>(Arrays.asList(
				new PdfSiteStatementEntryBean(
						"COPAY RX#8765432 FILL DATE: 08/10/2015", "24.00", "442-K101QJJ"),
				new PdfSiteStatementEntryBean("DRUG: INSULIN,ASPART,HUMAN 100 UNIT/ML INJ", "", ""),
				new PdfSiteStatementEntryBean("DAYS:90 QTY:l2 PHY:XABCRFI,XXZALA D  CHG:$24.00", "", ""),
				new PdfSiteStatementEntryBean("INTEREST/ADM. CHARGE (lnt:0.15 Adm:l.87 Other:0.00)", "2.02", ""),
				new PdfSiteStatementEntryBean("CHARGE SUSPENDED ON 08/12/2015 (#45365436)", "[78.45]", "517-K202IUK"))));
		siteStatement6.setTotalLabel("FACILITY # 517 TOTAL >>>");
		siteStatement6.setTotal("10.02");

		PdfSiteStatementBean siteStatement7 = new PdfSiteStatementBean();
		siteStatement7.setFacility("LITTLE ROCK, ARKANSAS. VA MEDICAL FACILITY # 598");
		siteStatement7.setRecords(new ArrayList<>(Arrays.asList(
				new PdfSiteStatementEntryBean(
						"COPAY RX#8765432 FILL DATE: 08/10/2015", "24.00", "442-K101QJJ"),
				new PdfSiteStatementEntryBean("DRUG: INSULIN,ASPART,HUMAN 100 UNIT/ML INJ", "", ""),
				new PdfSiteStatementEntryBean("DAYS:90 QTY:l2 PHY:XABCRFI,XXZALA D  CHG:$24.00", "", ""))));
		siteStatement7.setTotalLabel("FACILITY # 598 TOTAL >>>");
		siteStatement7.setTotal("27.00");

		PdfSiteStatementBean siteStatement8 = new PdfSiteStatementBean();
		siteStatement8.setFacility("NORTHAMPTON, MASSACHUSETTS. VA MEDICAL FACILITY # 631");
		siteStatement8.setRecords(new ArrayList<>(Arrays.asList(
				new PdfSiteStatementEntryBean("OUTPATIENT CARE VISIT DATE: 08/08/2015", "4.00", "631-K103TY6"),
				new PdfSiteStatementEntryBean(
						"COPAY RX#8765432 FILL DATE: 08/10/2015", "24.00", "442-K101QJJ"),
				new PdfSiteStatementEntryBean("DRUG: INSULIN,ASPART,HUMAN 100 UNIT/ML INJ", "", ""),
				new PdfSiteStatementEntryBean("DAYS:90 QTY:l2 PHY:XABCRFI,XXZALA D  CHG:$24.00", "", ""),
				new PdfSiteStatementEntryBean("PAYMENT POSTED ON 08/08/2015 (#35467111)", "24.00-", ""),
				new PdfSiteStatementEntryBean("PAYMENT POSTED ON 08/10/2015 (#35467121)", "36.00-", ""),
				new PdfSiteStatementEntryBean("PAYMENT POSTED ON 08/12/2015 (#35467132)", "35.00-", ""),
				new PdfSiteStatementEntryBean("PAYMENT POSTED ON 08/14/2015 (#35467243)", "4.00-", ""),
				new PdfSiteStatementEntryBean("CHARGE SUSPENDED 08/15/2015 (#45777436)", "[7.00]", "631-K177YHX"),
				new PdfSiteStatementEntryBean("CHARGE SUSPENDED 08/16/2015 (#45365777)", "[8.00]", "631-K422ZQX"))));
		siteStatement8.setTotalLabel("FACILITY # 631 TOTAL >>>");
		siteStatement8.setTotal("15.00");

		PdfSiteStatementBean siteStatement9 = new PdfSiteStatementBean();
		siteStatement9.setFacility("ANN ARBOR, MICHIGAN. VA MEDICAL FACILITY # 506");
		siteStatement9.setRecords(new ArrayList<>(Arrays.asList(
				new PdfSiteStatementEntryBean(
						"COPAY RX#8765432 FILL DATE: 08/10/2015", "24.00", "442-K101QJJ"),
				new PdfSiteStatementEntryBean("DRUG: INSULIN,ASPART,HUMAN 100 UNIT/ML INJ", "", ""),
				new PdfSiteStatementEntryBean("DAYS:90 QTY:l2 PHY:XABCRFI,XXZALA D  CHG:$24.00", "", ""),
				new PdfSiteStatementEntryBean("PAYMENT POSTED ON 08/24/2015 (#35463434)", "100.00-", ""),
				new PdfSiteStatementEntryBean("CHARGE SUSPENDED 08/18/2015 (#45365777)", "[89.00]", "506-K134APP"))));
		siteStatement9.setTotalLabel("FACILITY # 506 TOTAL >>>");
		siteStatement9.setTotal("11.00");

		siteStatementCollection.setSiteStatementL(new ArrayList<>(
				Arrays.asList(siteStatement1, siteStatement2, siteStatement3, siteStatement4, siteStatement5, siteStatement6, siteStatement7, siteStatement8, siteStatement9)));
		return Arrays.asList(siteStatementCollection);
	}

}
