package gov.va.cpss.jasper;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertTrue;
import static org.junit.Assert.fail;

import java.util.List;

import org.junit.Test;

/**
 * Test for Scanline.
 * 
 *
 */
public class ScanLineTest {

	@Test
	public final void testConvertValueToList1() {

		final int expectedSize = 2;

		// Input Value
		final int value = 5;

		// Convert
		final List<Integer> convertedL = ScanLine.convertValueToList(value, expectedSize);

		// Expect result of conversion {0, 5}
		assertEquals(expectedSize, convertedL.size());

		assertEquals(Integer.valueOf(0), convertedL.get(0));
		assertEquals(Integer.valueOf(5), convertedL.get(1));
	}

	@Test
	public final void testConvertValueToList2() {

		final int expectedSize = 2;

		// Input Value
		final int value = 23;

		// Convert
		final List<Integer> convertedL = ScanLine.convertValueToList(value, expectedSize);

		// Expect result of conversion {2, 3}
		assertEquals(expectedSize, convertedL.size());

		assertEquals(Integer.valueOf(2), convertedL.get(0));
		assertEquals(Integer.valueOf(3), convertedL.get(1));
	}

	@Test
	public final void testConvertValueToList3() {

		final int expectedSize = 2;

		// Input Value
		final int value = 71;

		// Convert
		final List<Integer> convertedL = ScanLine.convertValueToList(value, expectedSize);

		// Expect result of conversion {7, 1}
		assertEquals(expectedSize, convertedL.size());

		assertEquals(Integer.valueOf(7), convertedL.get(0));
		assertEquals(Integer.valueOf(1), convertedL.get(1));
	}

	@Test
	public final void testConvertValueToList4() {

		final int expectedSize = 4;

		// Input Value
		final int value = 2392;

		// Convert
		final List<Integer> convertedL = ScanLine.convertValueToList(value, expectedSize);

		// Expect result of conversion {2, 3, 9 , 2}
		assertEquals(expectedSize, convertedL.size());

		assertEquals(Integer.valueOf(2), convertedL.get(0));
		assertEquals(Integer.valueOf(3), convertedL.get(1));
		assertEquals(Integer.valueOf(9), convertedL.get(2));
		assertEquals(Integer.valueOf(2), convertedL.get(3));
	}

	@Test
	public final void testConvertValueToList5() {

		final int expectedSize = 4;

		// Input Value
		final int value = 3;

		// Convert
		final List<Integer> convertedL = ScanLine.convertValueToList(value, expectedSize);

		// Expect result of conversion {0, 0, 0 , 3}
		assertEquals(expectedSize, convertedL.size());

		assertEquals(Integer.valueOf(0), convertedL.get(0));
		assertEquals(Integer.valueOf(0), convertedL.get(1));
		assertEquals(Integer.valueOf(0), convertedL.get(2));
		assertEquals(Integer.valueOf(3), convertedL.get(3));
	}

	@Test
	public final void testNumberTooBig() {

		final int expectedSize = 2;

		// Input Value
		final int value = 2392;

		try {
			ScanLine.convertValueToList(value, expectedSize);
			fail("Invalid value digit length did not throw exception.");
		} catch (NumberFormatException e) {
			assertTrue(e.getMessage().contains("Value larger than expected: " + value));
		}
	}

	@Test
	public final void testScanLine1() {

		ScanLine scanLine = new ScanLine("672", "6720000001118VEGA", "31400");

		assertEquals("672**6720000001118VEGA*******00000000314005", scanLine.getCalculatedScanLine());
	}

	// 442**4420000001268GENDL******00000000024009
	@Test
	public final void testScanLine2() {

		ScanLine scanLine = new ScanLine("442", "4420000001268GENDL", "2400");

		assertEquals("442**4420000001268GENDL******00000000024009", scanLine.getCalculatedScanLine());
	}

	// 442**4420000001183EISMA******00000000131004
	@Test
	public final void testScanLine3() {

		ScanLine scanLine = new ScanLine("442", "4420000001183EISMA", "13100");

		assertEquals("442**4420000001183EISMA******00000000131004", scanLine.getCalculatedScanLine());
	}

	// 442**4420000001172FONTE******00000000048006
	@Test
	public final void testScanLine4() {

		ScanLine scanLine = new ScanLine("442", "4420000001172FONTE", "4800");

		assertEquals("442**4420000001172FONTE******00000000048006", scanLine.getCalculatedScanLine());
	}

	// 442**4420000001220GRINE******00000000048008
	@Test
	public final void testScanLine5() {

		ScanLine scanLine = new ScanLine("442", "4420000001220GRINE", "4800");

		assertEquals("442**4420000001220GRINE******00000000048008", scanLine.getCalculatedScanLine());
	}

}
