package gov.va.cpss.jasper;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertTrue;
import static org.junit.Assert.fail;
import static org.junit.Assume.assumeTrue;

import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;

/**
 * Test for PdfPatientStatementFactoryService class.
 * 
 *
 */
@RunWith(SpringJUnit4ClassRunner.class)
@ContextConfiguration(locations = { "/test-context.xml", "/cpss-context.xml" })
@SuppressWarnings({"nls", "static-method"})
public class PdfPatientStatementFactoryServiceTest {

	// Fix for Defect 616442
	// - Reformat Account Number
	// Yiping Yao - 02/5/2018
	@Value("${run.integration.test:false}")
	private Boolean runIntegrationTest;

	/**
	 * Only run these tests if property is set to run integration test.
	 */
	@Before
    public final void beforeTest() {
    	assumeTrue(this.runIntegrationTest.booleanValue());
    }

	@Test
	public final void testFormatted1() {
		
		final String input = "5400000000000000SELTZ";
		final String formatted = PdfPatientStatementFactoryService.formatAccountNumber(input);
		assertEquals("540 0000 0000 00000 SELTZ", formatted);
	}
	
	@Test
	public final void testFormatted2() {
		
		final String input = "5400000000000000SELTZVEGA";
		final String formatted = PdfPatientStatementFactoryService.formatAccountNumber(input);
		assertEquals("540 0000 0000 00000 SELTZ", formatted);
	}

	@Test
	public final void testFormatted3() {

		final String input = "5400000000000000S";
		final String formatted = PdfPatientStatementFactoryService.formatAccountNumber(input);
		assertEquals("540 0000 0000 00000 S", formatted);
	}
	
	@Test
	public final void testFormatted4() {

		final String input = "5400000000000000";
		try {
			PdfPatientStatementFactoryService.formatAccountNumber(input);
			fail("Invalid input (" + input + ") did not throw exception.");
		} catch (IndexOutOfBoundsException e) {
			assertTrue(e.getMessage().contains("Input (" + input + ") with position (16) is invalid"));
		}
	}

}
