package gov.va.cpss.email;

import java.util.Iterator;

/**
 * Provides an interface for a test email server fixture.
 * 
 * @author Brad Pickle
 *
 * @param <T>
 *            Type of the email message returned by the server.
 */
public interface MockEmailServer<T> {

	/**
	 * Start the server
	 */
	void start();

	/**
	 * Stop the server
	 */
	void stop();

	/**
	 * Get the number of email messages received by the server.
	 * 
	 * @return int number of email messages.
	 */
	int getReceivedEmailSize();

	/**
	 * Returns a parameterized Iterator of email messages received by the
	 * server.
	 * 
	 * @return Iterator of email messages.
	 */
	Iterator<T> getReceivedEmail();
}
