package gov.va.cpss.dao.impl;

import gov.va.cpss.dao.ProcessStatusDAO;
import gov.va.cpss.service.SendAPPSService;

/**
 *  This is a wrapper class
 * 
 *
 */
public abstract class SendAPPSServiceTestWrapper extends APPSDAOTestWrapper {

	private ProcessStatusDAO processStatusDAO;

	private SendAPPSService sendAppsService;

	public SendAPPSServiceTestWrapper(SendAPPSService sendAppsService) {
		this.sendAppsService = sendAppsService;
	}

	protected abstract void testImpl();

	@Override
	protected final void test() {
		try {
			testImpl();
		} finally {
			if (processStatusDAO != null) {
				sendAppsService.setProcessStatusDAO(processStatusDAO);
			}
		}
	}
}