package gov.va.cpss.dao.impl;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNotNull;
import static org.junit.Assert.assertTrue;
import static org.junit.Assume.assumeTrue;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;

import gov.va.cpss.dao.ProcessStatusDAO;
import gov.va.cpss.model.ProcessStatus;

@RunWith(SpringJUnit4ClassRunner.class)
@ContextConfiguration(locations = { "/test-context.xml", "/cpss-context.xml", "/dao-test-context.xml" })
/**
 * Unit tests for ProcessStatusDAOImpl.
 * 
 * @author Andrew Vance
 *
 */
public final class ProcessStatusDAOImplTest {

	@Value("${run.integration.test:false}")
	private Boolean runIntegrationTest;

	@Autowired
	private ProcessStatusDAO processStatusDao;

	private List<ProcessStatus.Status> processStatusEnumL;

	@Before
	public final void beforeTest() {
		assumeTrue(runIntegrationTest);

		buildProcessStatusEnumL();
	}

	@Test
	public final void testStatusTypeList() {
		processStatusDao.initTypeMaps();
		final List<ProcessStatus> statusTypeList = processStatusDao.statusTypeList();
		assertNotNull(statusTypeList);
		assertEquals(statusTypeList.size(), processStatusEnumL.size());

		final List<String> statusNameL = new ArrayList<String>();
		for (ProcessStatus processStatus : statusTypeList) {
			statusNameL.add(processStatus.getName());
		}
		for (ProcessStatus.Status status : processStatusEnumL) {
			assertTrue(statusNameL.contains(status.getName()));
		}
	}

	@Test
	public final void testGetStatusFromEnum() {
		final Set<Integer> statusIdS = new HashSet<Integer>();

		for (ProcessStatus.Status status : processStatusEnumL) {
			final int statusId = processStatusDao.getStatusFromEnum(status);
			assertTrue(statusId > 0);
			statusIdS.add(statusId);
		}

		assertEquals(statusIdS.size(), processStatusEnumL.size());
	}

	@Test
	public final void testGetStatusType() {
		final Set<ProcessStatus> processStatusS = new HashSet<ProcessStatus>();

		for (int statusId = 1; statusId <= processStatusEnumL.size(); statusId++) {
			final ProcessStatus pS = processStatusDao.getStatusType(statusId);
			assertNotNull(pS);
			processStatusS.add(pS);
		}

		assertEquals(processStatusS.size(), processStatusEnumL.size());
	}

	private final void buildProcessStatusEnumL() {
		processStatusEnumL = new ArrayList<ProcessStatus.Status>();
		processStatusEnumL.add(ProcessStatus.Status.INITIAL);
		processStatusEnumL.add(ProcessStatus.Status.NEW);
		processStatusEnumL.add(ProcessStatus.Status.PROCESSED);
		processStatusEnumL.add(ProcessStatus.Status.SENT);
		processStatusEnumL.add(ProcessStatus.Status.ACK);
		processStatusEnumL.add(ProcessStatus.Status.REPLACED);
		processStatusEnumL.add(ProcessStatus.Status.SUCCESS);
		processStatusEnumL.add(ProcessStatus.Status.ERROR);
		processStatusEnumL.add(ProcessStatus.Status.OTHER);
	}
}