package gov.va.cpss.dao.impl;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNotNull;
import static org.junit.Assert.assertTrue;
import static org.junit.Assume.assumeTrue;

import java.sql.Timestamp;
import java.util.Calendar;

import javax.sql.DataSource;

import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;

import gov.va.cpss.dao.PrintAckRecDAO;
import gov.va.cpss.model.printack.PrintAckRec;

/**
 * Unit tests the PrintAckRecDAOImpl class.
 * 
 * @author Brad Pickle
 *
 */
@RunWith(SpringJUnit4ClassRunner.class)
@ContextConfiguration(locations = { "/test-context.xml", "/cpss-context.xml", "/dao-test-context.xml" })
public class PrintAckRecDAOImplTest {

	@Value("${run.integration.test:false}")
	private Boolean runIntegrationTest;

	@Autowired
	private CBSDAOImplUtils cbsDAOImplUtils;

	@Autowired
	private PrintAckRecDAO printAckRecDao;

	private JdbcTemplate jdbcTemplate;

	@Autowired
	public void setDataSource(DataSource dataSource) {
		jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/**
	 * Only run these tests if property is set to run integration test.
	 */
	@Before
	public final void beforeTest() {
		assumeTrue(runIntegrationTest);
	}

	/**
	 * Tests the insert(), updateStatus() and get() methods of
	 * PrintAckRecDAOImpl
	 */
	@Test
	public final void testInsertUdpateGet() {
		(new CBSDAOTestWrapper() {

			@Override
			protected void test() {
				// Set up the PrintAckRec
				final Timestamp dateReceived = new Timestamp(Calendar.getInstance().getTime().getTime());
				final String stationNum = "1";
				final int batchRunId = 1;
				final String fileName = "printAck.txt";

				final int printAckInitialStatusId = 1;
				final int printAckSuccessStatusId = 1;

				final PrintAckRec printAckRec = new PrintAckRec();
				printAckRec.setDateReceived(dateReceived);
				printAckRec.setStationNum(stationNum);
				printAckRec.setStatusId(printAckInitialStatusId);
				printAckRec.setFileName(fileName);
				printAckRec.setBatchRunId(batchRunId);

				final PrintAckRec originalPrintAckRec = cbsDAOImplUtils.copyPrintAckRec(printAckRec);

				final long id = printAckRecDao.insert(printAckRec);
				getPrintAckRecIdS().add(id);

				assertEquals(id, printAckRec.getId());
				assertTrue(printAckRec.getId() > 0);
				assertNotNull(printAckRec.getCreatedBy());
				assertNotNull(printAckRec.getCreatedDate());
				assertNotNull(printAckRec.getModifiedBy());
				assertNotNull(printAckRec.getModifiedDate());

				// Fields not set before save
				originalPrintAckRec.setId(printAckRec.getId());
				originalPrintAckRec.setCreatedBy(printAckRec.getCreatedBy());
				originalPrintAckRec.setCreatedDate(printAckRec.getCreatedDate());
				originalPrintAckRec.setModifiedBy(printAckRec.getModifiedBy());
				originalPrintAckRec.setModifiedDate(printAckRec.getModifiedDate());

				// Assert relevant fields equal with original
				cbsDAOImplUtils.comparePrintAckRec(printAckRec, originalPrintAckRec);

				final PrintAckRec newPrintAckRec = printAckRecDao.get(id);

				assertNotNull(newPrintAckRec);

				cbsDAOImplUtils.comparePrintAckRec(printAckRec, newPrintAckRec);

				printAckRec.setStatusId(printAckSuccessStatusId);
				printAckRecDao.updateStatus(printAckRec);

				final PrintAckRec updatedPrintAckRec = printAckRecDao.get(id);

				assertNotNull(updatedPrintAckRec);

				cbsDAOImplUtils.comparePrintAckRec(printAckRec, updatedPrintAckRec);

			}

		}).run(jdbcTemplate);
	}

}
