package gov.va.cpss.dao.impl;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNotNull;

import java.util.List;

import org.junit.Test;

import gov.va.cpss.model.BatchRun;
import gov.va.cpss.model.fps.PSPatient;
import gov.va.cpss.model.fps.PSReceived;
import gov.va.cpss.model.fps.PSSite;

/**
 * Unit test for PSPatientDAOImpl class.
 *
 */
public final class PSPatientDAOImplTest extends AbstractCbsDaoImplTest {
	@Test
	public final void test() {
		final PSPatient psPatientExpected = testPsPatientL.get(0);
		
		// Test getLastIndex()
		assertEquals(psPatientExpected.getId(), (long)psPatientDao.getLastIndex());
		
		final List<PSPatient> psPatientRetrievedL = psPatientDao.getAllByPSSiteID(testPsSiteL.get(0));
		assertNotNull(psPatientRetrievedL);
		assertEquals(testPsPatientL.size(), psPatientRetrievedL.size());
		assertPsPatientEquals(psPatientExpected, psPatientRetrievedL.get(0));
	}
	
	@Override
	protected void insertTestData() {
		// Create batch run
		final BatchRun batchRun = cbsDaoImplUtils.createTestBatchRun();
		batchRun.setId(batchRunDao.save(batchRun));		
		testBatchRunL.add(batchRun);
		
		// Create PSReceived
		final PSReceived psReceived1 = cbsDaoImplUtils.createTestPSReceived(batchRun);
		psReceived1.setId(psReceivedDao.save(psReceived1));
		testPsReceivedL.add(psReceived1);
		
		// Create PSSite;
		final PSSite psSite1 = cbsDaoImplUtils.createTestPSSite(psReceived1);
		psSite1.setId(psSiteDao.save(psSite1));
		testPsSiteL.add(psSite1);
		
		// Create PSPatient
		final PSPatient psPatient = cbsDaoImplUtils.createTestPSPatient(psSite1);
		psPatient.setId(psPatientDao.save(psPatient));
		testPsPatientL.add(psPatient);
	}
	
	private static void assertPsPatientEquals(final PSPatient expected, final PSPatient retrieved) {
		assertEquals(expected.getPsSite().getId(), retrieved.getPsSite().getId());
		assertEquals(expected.getPatientAccount(), retrieved.getPatientAccount());
		assertEquals(expected.getPatientLastName(), retrieved.getPatientLastName());
		assertEquals(expected.getPatientFirstName(), retrieved.getPatientFirstName());
		assertEquals(expected.getPatientMiddleName(), retrieved.getPatientMiddleName());
		assertEquals(expected.getAddress1(), retrieved.getAddress1());
		assertEquals(expected.getAddress2(), retrieved.getAddress2());
		assertEquals(expected.getAddress3(), retrieved.getAddress3());
		assertEquals(expected.getCity(), retrieved.getCity());
		assertEquals(expected.getState(), retrieved.getState());
		assertEquals(expected.getZipCode(), retrieved.getZipCode());
		assertEquals(expected.getCountryName(), retrieved.getCountryName());
		assertEquals(expected.getAmountDue(), retrieved.getAmountDue());
		assertEquals(expected.getPrevBalance(), retrieved.getPrevBalance());
		assertEquals(expected.getTotalCharges(), retrieved.getTotalCharges());
		assertEquals(expected.getTotalCredits(), retrieved.getTotalCredits());
		assertEquals(expected.getNewBalance(), retrieved.getNewBalance());
		assertEquals(expected.getSpecialNotes(), retrieved.getSpecialNotes());
		assertEquals(expected.getSpecialNotesForLateSites1(), retrieved.getSpecialNotesForLateSites1());
		assertEquals(expected.getSpecialNotesForLateSites2(), retrieved.getSpecialNotesForLateSites2());
		assertEquals(expected.getRightsObligationParagraphCodes(), retrieved.getRightsObligationParagraphCodes());
		assertEquals(expected.getNumOfLines(), retrieved.getNumOfLines());
		assertEquals(expected.getDfnNumber(), retrieved.getDfnNumber());
		assertEquals(expected.getLargeFontInd(), retrieved.getLargeFontInd());
		assertEquals(expected.getIcnNumber(), retrieved.getIcnNumber());
		assertEquals(expected.getAddressFlag(), retrieved.getAddressFlag());
		assertEquals(expected.getLastBillPrepDate().getTime(), retrieved.getLastBillPrepDate().getTime(), 1000);
	}
}
