package gov.va.cpss.dao.impl;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNotNull;
import static org.junit.Assert.assertTrue;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;

import gov.va.cpss.model.cbs.CBSAccount;

@RunWith(SpringJUnit4ClassRunner.class)
@ContextConfiguration(locations = { "/test-context.xml", "/cpss-context.xml"})
/**
 * Unit test for CBSAccountDAOImpl
 * 
 * @author Andrew Vance
 */
public final class CBSAccountDAOImplTest extends AbstractApsDaoImplTest {
	
	@Test
	public final void testSelectByICN() {
		final CBSAccount cbsAccountExpected = testCbsAccountL.get(0);
		
		final Long cbsAccountRetrievedId = cbsAccountDao.selectByICN(cbsAccountExpected.getIcn());
		
		assertEquals(cbsAccountExpected.getId(), (long)cbsAccountRetrievedId);
	}
	
	@Test
	public final void testGetByICN() {
		final String icn = "definitelyInvalid";
		
		final Long newCbsAccountId = cbsAccountDao.getByICN(icn);
		
		assertTrue(newCbsAccountId > 0);
		
		final CBSAccount cbsAccount = new CBSAccount();
		cbsAccount.setId(newCbsAccountId);
		
		testCbsAccountL.add(cbsAccount);
	}
	
	@Test
	public final void testSelectICNById() {
		final CBSAccount cbsAccountExpected = testCbsAccountL.get(0);
		
		final String icnRetrieved = cbsAccountDao.selectICNById(cbsAccountExpected.getId());
		
		assertEquals(cbsAccountExpected.getIcn(), icnRetrieved);
	}
	
	@Test
	public final void testBatchSelect() {
		final String[] icns = new String[testCbsAccountL.size()];
		for(int idx = 0; idx < icns.length; idx++) {
			icns[idx] = testCbsAccountL.get(idx).getIcn();
		}
		
		final List<CBSAccount> cbsAccountRetrievedL = cbsAccountDao.batchSelect(icns);
		
		assertTrue(cbsAccountRetrievedL.stream().map(CBSAccount::getId).collect(Collectors.toList())
				.containsAll(testCbsAccountL.stream().map(CBSAccount::getId).collect(Collectors.toList())));
	}
	
	@Test
	public final void testBatchInsertAndReturnCBSAccounts() {
		final Set<String> icnS = new HashSet<String>();
		icnS.add("newTestIcn22");
		icnS.add("newTestIcn33");
		icnS.add("newTestIcn44");
		
		final List<CBSAccount> retrievedAccountL = cbsAccountDao.batchInsertAndReturnCBSAccounts(icnS);
		testCbsAccountL.addAll(retrievedAccountL);
		
		assertNotNull(retrievedAccountL);
		
		final List<String> retrievedIcnL = retrievedAccountL.stream().map(CBSAccount::getIcn).collect(Collectors.toList());
		
		icnS.forEach(icn -> assertTrue(retrievedIcnL.contains(icn)));
	}
	
	@Override
	protected final void insertTestData() {
		final String icn1 = "icnForJUnitTest1";
		final CBSAccount cbsAccount1 = new CBSAccount();
		cbsAccount1.setIcn(icn1);
		cbsAccount1.setId(cbsAccountDao.save(icn1));
		
		final String icn2 = "icnForJUnitTest2";
		final CBSAccount cbsAccount2 = new CBSAccount();
		cbsAccount2.setIcn(icn2);
		cbsAccount2.setId(cbsAccountDao.save(icn2));
		
		testCbsAccountL = new ArrayList<CBSAccount>();
		testCbsAccountL.add(cbsAccount1);
		testCbsAccountL.add(cbsAccount2);
	}
}
