package gov.va.cpss.dao.impl;

import static org.junit.Assert.*;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;

import gov.va.cpss.dao.BatchTypeDAO;
import gov.va.cpss.model.BatchType;

@RunWith(SpringJUnit4ClassRunner.class)
@ContextConfiguration(locations = { "/test-context.xml", "/cpss-context.xml"})
/**
 * Unit tests for BatchTypeDAOImpl
 * 
 * @author Andrew Vance
 *
 */
public final class BatchTypeDAOImplTest {

	@Autowired
	private BatchTypeDAO batchTypeDao;
	
	private List<BatchType.JobType> jobTypeL;
	
	@Before
	public final void beforeTest() {
		buildJobTypeL();
	}
	
	@After
	public final void afterTest() {
		
	}
	
	@Test
	public final void testBatchTypeList() {
		batchTypeDao.initTypeMaps();
		final List<BatchType> batchTypeRetrievedL = batchTypeDao.batchTypeList();
		
		assertNotNull(batchTypeRetrievedL);
		
		final List<String> jobTypeRetrievedL = 
				batchTypeRetrievedL.stream().map(BatchType::getName).collect(Collectors.toList());
		
		assertTrue(jobTypeRetrievedL
				.containsAll(jobTypeL.stream().map(BatchType.JobType::getName).collect(Collectors.toList())));
	}
	
	@Test
	public final void testGet() {
		final List<BatchType> batchTypeL = batchTypeDao.batchTypeList();
		
		for(BatchType batchType : batchTypeL) {
			assertEquals(batchType.getName(), batchTypeDao.getBatchType(batchType.getId()).getName());
		}
	}
	
	private void buildJobTypeL() {
		jobTypeL = new ArrayList<BatchType.JobType>();
		jobTypeL.add(BatchType.JobType.DAILY);
		jobTypeL.add(BatchType.JobType.MANUAL);
		jobTypeL.add(BatchType.JobType.SCHEDULED);
		jobTypeL.add(BatchType.JobType.SPECIFIED);
	}	
}
