package gov.va.cpss.dao.impl;

import static org.junit.Assert.assertTrue;
import static org.junit.Assume.assumeTrue;

import java.util.List;
import java.util.stream.Collectors;

import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;

import gov.va.cpss.dao.BatchStatusDAO;
import gov.va.cpss.model.BatchStatus;
import gov.va.cpss.model.BatchStatus.JobStatus;

@RunWith(SpringJUnit4ClassRunner.class)
@ContextConfiguration(locations = { "/test-context.xml", "/cpss-context.xml"})
/**
 * Unit test for BatchStatusDAOImpl
 * 
 * @author Andrew Vance
 */
public final class BatchStatusDAOImplTest {
	
	@Value("${run.integration.test:false}")
	private Boolean runIntegrationTest;
	
	@Autowired
	private BatchStatusDAO batchStatusDao;
	
	@Before
	public final void beforeTest() {
		assumeTrue(runIntegrationTest);
	}
	
	@After
	public final void afterTest() {
		
	}
	
	@Test
	public final void testStatusTypeList() {
		batchStatusDao.initTypeMaps();
		List<BatchStatus> batchStatusL = batchStatusDao.statusTypeList();
		
		List<String> batchStatusNameL = batchStatusL.stream().map(BatchStatus::getName).collect(Collectors.toList());
		assertTrue(batchStatusNameL.contains("NotRunning"));
		assertTrue(batchStatusNameL.contains("Running"));
		assertTrue(batchStatusNameL.contains("Complete"));
		assertTrue(batchStatusNameL.contains("Error"));
	}
	
	@Test
	public final void testGet() {
		final int retrievedBatchStatusId = batchStatusDao.getStatusFromEnum(JobStatus.COMPLETE);
		assertTrue(retrievedBatchStatusId > -1);
		
		final BatchStatus retrievedBatchStatus = batchStatusDao.getStatusType(retrievedBatchStatusId);
		assertTrue(retrievedBatchStatus.getJobStatus().equals(JobStatus.COMPLETE));
	}
}
