package gov.va.cpss.dao.impl;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertTrue;

import java.sql.Date;
import java.sql.Timestamp;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;

import gov.va.cpss.model.BatchRun;
import gov.va.cpss.model.BatchRunProcess;
import gov.va.cpss.model.BatchStatus.JobStatus;
import gov.va.cpss.model.ProcessStatus;

/**
 * Unit tests for the BatchRunProcessDAOImpl class.
 *
 *
 */
@RunWith(SpringJUnit4ClassRunner.class)
@ContextConfiguration(locations = { "/test-context.xml", "/cpss-context.xml", "/apps-dao-test-context.xml" })
public final class BatchRunProcessDAOImplTest extends AbstractApsDaoImplTest {

	@Test
	public final void testGetUpdate() {
		final BatchRunProcess batchRunProcessExpected = testBatchRunProcessL.get(0);
		
		// Simple get
		final BatchRunProcess batchRunProcessRetrieved = batchRunProcessDao.get(batchRunProcessExpected.getId());		
		assertBatchRunProcessEquals(batchRunProcessExpected, batchRunProcessRetrieved);
		
		// Test updateStatus
		batchRunProcessExpected.setStatusId(processStatusDao.getStatusFromEnum(ProcessStatus.Status.REPLACED));
		batchRunProcessDao.updateStatus(batchRunProcessExpected);		
		final BatchRunProcess batchRunProcessStatusUpdated = batchRunProcessDao.get(batchRunProcessExpected.getId());
		assertBatchRunProcessEquals(batchRunProcessExpected, batchRunProcessStatusUpdated);
		
		// Test update
		batchRunProcessExpected.setFileName("updated.test");
		batchRunProcessExpected.setProcessDate(Date.from(Instant.now()));
		batchRunProcessDao.update(batchRunProcessExpected);
		final BatchRunProcess batchRunProcessUpdated = batchRunProcessDao.get(batchRunProcessExpected.getId());
		assertBatchRunProcessEquals(batchRunProcessExpected, batchRunProcessUpdated);
	}
	
	@Test
	public final void testGetBatchRunProcessesInStatus() {
		final BatchRunProcess batchRunProcessExpected = testBatchRunProcessL.get(0);
		
		final List<BatchRunProcess> batchRunProcessRetrievedL = batchRunProcessDao.getBatchRunProcessesInStatus(batchRunProcessExpected.getStatusId());
		
		assertTrue(batchRunProcessRetrievedL.stream().map(BatchRunProcess::getId).collect(Collectors.toList()).contains(batchRunProcessExpected.getId()));
	
		batchRunProcessRetrievedL.forEach(brp -> assertEquals(batchRunProcessExpected.getStatusId(), brp.getStatusId()));
	}
	
	@Test
	public final void testListUpdateStatus() {
		final BatchRunProcess batchRunProcessExpected = testBatchRunProcessL.get(0);
		
		final List<Long> batchRunProcessIdToUpdateL = new ArrayList<Long>();
		batchRunProcessIdToUpdateL.add(batchRunProcessExpected.getId());
		
		final int newStatusId = processStatusDao.getStatusFromEnum(ProcessStatus.Status.PROCESSED);
		
		batchRunProcessDao.updateStatus(batchRunProcessIdToUpdateL, newStatusId);
		
		final BatchRunProcess batchRunProcessRetrieved = batchRunProcessDao.get(batchRunProcessExpected.getId());
		
		assertEquals(newStatusId, batchRunProcessRetrieved.getStatusId());
	}
	
	@Override
	protected void insertTestData() {
		// Create batchRun
		final BatchRun batchRun = new BatchRun();
		batchRun.setStatusId(batchStatusDao.getStatusFromEnum(JobStatus.COMPLETE));
		batchRun.setJobId(batchJobDao.batchList().get(0).getId());
		batchRun.setStartDate(Timestamp.from(Instant.now()));
		batchRun.setId(batchRunDao.save(batchRun));
		testBatchRunL.add(batchRun);
		
		// Create batchRunProcess
		final BatchRunProcess brpGen = new BatchRunProcess();
		brpGen.setBatchRunId(batchRun.getId());
		brpGen.setFileName("genfilename.test");
		brpGen.setProcessDate(Date.from(Instant.now()));
		brpGen.setStatusId(processStatusDao.getStatusFromEnum(ProcessStatus.Status.NEW));
		brpGen.setId(batchRunProcessDao.save(brpGen));
		testBatchRunProcessL.add(brpGen);
	}
	
	private static void assertBatchRunProcessEquals(final BatchRunProcess batchRunProcessExpected, final BatchRunProcess batchRunProcessRetrieved) {
		assertEquals(batchRunProcessExpected.getId(), batchRunProcessRetrieved.getId());
		assertEquals(batchRunProcessExpected.getBatchRunId(), batchRunProcessRetrieved.getBatchRunId());
		assertEquals(batchRunProcessExpected.getFileName(), batchRunProcessRetrieved.getFileName());
		assertEquals(batchRunProcessExpected.getProcessDate().getTime(), batchRunProcessRetrieved.getProcessDate().getTime(), 1000);
		assertEquals(batchRunProcessExpected.getStatusId(), batchRunProcessRetrieved.getStatusId());
	}

}
