package gov.va.cpss.dao.impl;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNotNull;

import java.util.List;

import org.junit.Test;

import gov.va.cpss.model.apps.APSSitePatient;
import gov.va.cpss.model.apps.APSSiteStmt;
import gov.va.cpss.model.apps.APSStmt;
import gov.va.cpss.model.cbs.CBSAccount;

/**
 * Unit tests for APSSitePatientDAOImpl.
 * 
 * @author Andrew Vance
 */
public class APSSitePatientDAOImplTest extends AbstractApsDaoImplTest {

	@Test
	public final void testGetSitePatientForSiteStatement(){ 
		final APSSitePatient apsSitePatientExpected = testApsSitePatientL.get(0);
		
		final APSSitePatient apsSitePatientRetrieved = 
				apsSitePatientDao.getSitePatientForSiteStatement(apsSitePatientExpected.getSiteStmtId());
	
		assertNotNull(apsSitePatientRetrieved);
		
		assertApsSitePatientEquals(apsSitePatientExpected, apsSitePatientRetrieved);
	}
	
	@Test
	public final void testSimpleGet() {
		final APSSitePatient apsSitePatientExpected = testApsSitePatientL.get(0);
		
		@SuppressWarnings("unchecked")
		final List<APSSitePatient> apsSitePatientRetrievedL = (List<APSSitePatient>)apsSitePatientDao.select("WHERE ID = " + apsSitePatientExpected.getId(), "");
	
		assertNotNull(apsSitePatientRetrievedL);
		assertEquals(1, apsSitePatientRetrievedL.size());
		
		final APSSitePatient apsSitePatientRetrieved = apsSitePatientRetrievedL.get(0);
		
		assertApsSitePatientEquals(apsSitePatientExpected, apsSitePatientRetrieved);
	}
	
	@Override
	protected void insertTestData() {
		// Create CBSAccount
		final CBSAccount cbsAccount = new CBSAccount();
		cbsAccount.setIcn("apssitepatient");
		cbsAccount.setId(cbsAccountDao.save(cbsAccount.getIcn()));
		testCbsAccountL.add(cbsAccount);
		
		// Create APSStmt
		final APSStmt apsStmt = appsDaoImplUtils.createTestAPSStmt(cbsAccount);
		apsStmt.setId(apsStmtDao.save(apsStmt));
		testApsStmtL.add(apsStmt);
		
		// Create APSSiteStmt		
		final APSSiteStmt apsSiteStmt = appsDaoImplUtils.createTestAPSSiteStmt(apsStmt);
		apsSiteStmt.setId(apsSiteStmtDao.save(apsSiteStmt));
		testApsSiteStmtL.add(apsSiteStmt);
		
		// Create APSSitePatient
		final APSSitePatient apsSitePatient = appsDaoImplUtils.createTestAPSSitePatient(apsSiteStmt);
		apsSitePatient.setId(apsSitePatientDao.save(apsSitePatient));
		testApsSitePatientL.add(apsSitePatient);		
	}
	
	private static void assertApsSitePatientEquals(APSSitePatient apsSitePatientExpected, APSSitePatient apsSitePatientRetrieved){
		assertEquals(apsSitePatientExpected.getId(), apsSitePatientRetrieved.getId());		
		assertEquals(apsSitePatientExpected.getAccountNumber(), apsSitePatientRetrieved.getAccountNumber());
		assertEquals(apsSitePatientExpected.getAddress1(), apsSitePatientRetrieved.getAddress1());
		assertEquals(apsSitePatientExpected.getAddress2(), apsSitePatientRetrieved.getAddress2());
		assertEquals(apsSitePatientExpected.getAddress3(), apsSitePatientRetrieved.getAddress3());
		assertEquals(apsSitePatientExpected.getCity(), apsSitePatientRetrieved.getCity());
		assertEquals(apsSitePatientExpected.getCountry(), apsSitePatientRetrieved.getCountry());
		assertEquals(apsSitePatientExpected.getDfn(), apsSitePatientRetrieved.getDfn());
		assertEquals(apsSitePatientExpected.getFirstName(), apsSitePatientRetrieved.getFirstName());
		assertEquals(apsSitePatientExpected.getIcn(), apsSitePatientRetrieved.getIcn());
		assertEquals(apsSitePatientExpected.getLastName(), apsSitePatientRetrieved.getLastName());
		assertEquals(apsSitePatientExpected.getMiddleName(), apsSitePatientRetrieved.getMiddleName());
		assertEquals(apsSitePatientExpected.getSiteStmtId(), apsSitePatientRetrieved.getSiteStmtId());
		assertEquals(apsSitePatientExpected.getState(), apsSitePatientRetrieved.getState());
		assertEquals(apsSitePatientExpected.getStatusId(), apsSitePatientRetrieved.getStatusId());
		assertEquals(apsSitePatientExpected.getZipCode(), apsSitePatientRetrieved.getZipCode());
	}

}
