package gov.va.cpss.dao.impl;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNotNull;
import static org.junit.Assert.assertTrue;

import java.util.List;
import java.util.stream.Collectors;

import org.junit.Test;

import gov.va.cpss.model.apps.APSPayment;
import gov.va.cpss.model.apps.APSSiteStmt;
import gov.va.cpss.model.apps.APSStmt;
import gov.va.cpss.model.cbs.CBSAccount;

/**
 * Unit tests for APSPaymentDAOImpl.
 * 
 * @author Andrew Vance
 */
public final class APSPaymentDAOImplTest extends AbstractApsDaoImplTest {

	@Test
	public void testGetPaymentsForSiteStmt() {
		final List<APSPayment> apsPaymentRetrievedL = apsPaymentDao.getPaymentsForSiteStmt(testApsSiteStmtL.get(0).getId());
		assertNotNull(apsPaymentRetrievedL);
		assertEquals(testApsPaymentL.size(), apsPaymentRetrievedL.size());
		assertTrue(apsPaymentRetrievedL.stream().map(APSPayment::getId).collect(Collectors.toList())
				.containsAll(testApsPaymentL.stream().map(APSPayment::getId).collect(Collectors.toList())));
		
		final APSPayment apsPaymentExpected = testApsPaymentL.get(0);

		final APSPayment apsPaymentRetrieved = testApsPaymentL.stream().filter(apsPayment -> apsPayment.getId() == apsPaymentExpected.getId())
				.collect(Collectors.toList()).get(0);
		
		assertAPSPaymentEquals(apsPaymentExpected, apsPaymentRetrieved);
	}
	
	@Override
	protected void insertTestData() {
		// Create CBSAccount
		final CBSAccount cbsAccount = appsDaoImplUtils.createTestCbsAccount();
		cbsAccount.setId(cbsAccountDao.save(cbsAccount.getIcn()));
		testCbsAccountL.add(cbsAccount);
		
		// Create APSStmt
		final APSStmt apsStmt = appsDaoImplUtils.createTestAPSStmt(cbsAccount);
		apsStmt.setId(apsStmtDao.save(apsStmt));
		testApsStmtL.add(apsStmt);
		
		// Create APSSiteStmt
		final APSSiteStmt apsSiteStmt = appsDaoImplUtils.createTestAPSSiteStmt(apsStmt);
		apsSiteStmt.setId(apsSiteStmtDao.save(apsSiteStmt));
		testApsSiteStmtL.add(apsSiteStmt);
		
		// Create APSPayments
		final APSPayment apsPayment1 = appsDaoImplUtils.createTestAPSPayment(apsSiteStmt);
		apsPayment1.setId(apsPaymentDao.save(apsPayment1));
		testApsPaymentL.add(apsPayment1);
		
		final APSPayment apsPayment2 = appsDaoImplUtils.createTestAPSPayment(apsSiteStmt);
		apsPayment2.setId(apsPaymentDao.save(apsPayment2));
		testApsPaymentL.add(apsPayment2);		
	}
	
	private static void assertAPSPaymentEquals(final APSPayment expected, final APSPayment retrieved) {
		assertEquals(expected.getId(), retrieved.getId());
		assertEquals(expected.getSiteStmtId(), retrieved.getSiteStmtId());
		assertEquals(expected.getMonth(), retrieved.getMonth());
		assertEquals(expected.getDatePosted().getTime(), retrieved.getDatePosted().getTime(), 1000);
		assertEquals(expected.getTransactionAmount(), retrieved.getTransactionAmount());
		assertEquals(expected.getTransactionAmountStr(), retrieved.getTransactionAmountStr());
	}

}
