package gov.va.cpss.dao.impl;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNotNull;
import static org.junit.Assert.assertTrue;

import java.util.List;
import java.util.stream.Collectors;

import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;

import gov.va.cpss.model.AITCDollar;
import gov.va.cpss.model.apps.APSDetails;
import gov.va.cpss.model.apps.APSPatient;
import gov.va.cpss.model.apps.APSReceived;
import gov.va.cpss.model.apps.APSSite;

@RunWith(SpringJUnit4ClassRunner.class)
@ContextConfiguration(locations = { "/test-context.xml", "/cpss-context.xml", "/apps-dao-test-context.xml" })
/**
 * Unit test for APSDetailsDAOImpl
 * @author Andrew Vance
 *
 */
public final class APSDetailsDAOImplTest extends AbstractApsDaoImplTest {	
	@Test
	public final void testSimpleGet() {
		final APSDetails apsDetailsExpected = testApsDetailsL.get(0);
		
		final APSDetails apsDetailsRetrieved = (APSDetails)(apsDetailsDao.select("where id = " + apsDetailsExpected.getId(), "").get(0));
	
		assertEquals(apsDetailsExpected.getId(), apsDetailsRetrieved.getId());
		assertEquals(apsDetailsExpected.getApsPatientId(), apsDetailsRetrieved.getApsPatientId());
		assertEquals(apsDetailsExpected.getDatePosted().getTime(), apsDetailsRetrieved.getDatePosted().getTime(), 1000);
		assertEquals(apsDetailsExpected.getTransactionAmount().getDouble(), apsDetailsRetrieved.getTransactionAmount().getDouble(), 0);
		assertEquals(apsDetailsExpected.getType(), apsDetailsRetrieved.getType());
		assertEquals(apsDetailsExpected.getStatusId(), apsDetailsRetrieved.getStatusId());		
	}
	
	@Test
	public final void testGetAllByAPSSite() {
		final APSSite apsSite = testApsSiteL.get(0);
		
		final List<APSDetails> apsDetailsRetrievedL = apsDetailsDao.getAllByAPSSite(apsSite);
		
		assertNotNull(apsDetailsRetrievedL);
		
		final List<Long> apsDetailsRetrievedIdL = apsDetailsRetrievedL.stream().map(APSDetails::getId).collect(Collectors.toList());
		
		testApsDetailsL.forEach(apsDetails -> assertTrue(apsDetailsRetrievedIdL.contains(apsDetails.getId())));
	}
	
	@Test
	public final void testGetByPatients() {
		final List<APSDetails> apsDetailsRetrievedL = apsDetailsDao.getByPatients(testApsPatientL);
		
		assertNotNull(apsDetailsRetrievedL);
		
		final List<Long> apsDetailsRetrievedIdL = apsDetailsRetrievedL.stream().map(APSDetails::getId).collect(Collectors.toList());
	
		testApsDetailsL.forEach(apsDetails -> assertTrue(apsDetailsRetrievedIdL.contains(apsDetails.getId())));
	}
	
	protected final void insertTestData(){
		// Create APSReceived
		final APSReceived apsReceived = appsDaoImplUtils.createTestAPSReceived();		
		apsReceived.setId(apsReceivedDao.save(apsReceived));
		testApsReceivedL.add(apsReceived);
		
		// Create APSSite
		final APSSite apsSite = appsDaoImplUtils.createTestApsSite(apsReceived);
        apsSite.setId(apsSiteDao.save(apsSite));
        testApsSiteL.add(apsSite);
		
        // Create APSPatients
        final APSPatient apsPatient1 = appsDaoImplUtils.createTestApsPatient(apsSite);
        apsPatient1.setId(apsPatientDao.save(apsPatient1));
        testApsPatientL.add(apsPatient1);
        
        final APSPatient apsPatient2 = appsDaoImplUtils.createTestApsPatient(apsSite);
        apsPatient2.setIcn("testicn5353321");
        apsPatient2.setDfn(19182316);
        apsPatient2.setAccountNumber("oldaccntnum32");
        apsPatient2.setId(apsPatientDao.save(apsPatient2));
        testApsPatientL.add(apsPatient2);
        
        // Create APSDetails
        final APSDetails apsDetails1 = appsDaoImplUtils.createTestApsDetails(apsPatient1);
        apsDetails1.setId(apsDetailsDao.save(apsDetails1));
        testApsDetailsL.add(apsDetails1);
        
        final APSDetails apsDetails2 = appsDaoImplUtils.createTestApsDetails(apsPatient1);
        apsDetails2.setTransactionAmount(new AITCDollar(1111));
        apsDetails2.setId(apsDetailsDao.save(apsDetails2));
        testApsDetailsL.add(apsDetails2);
        
        final APSDetails apsDetails3 = appsDaoImplUtils.createTestApsDetails(apsPatient2);
        apsDetails3.setTransactionAmount(new AITCDollar(1311));
        apsDetails3.setId(apsDetailsDao.save(apsDetails3));
        testApsDetailsL.add(apsDetails3);
	}
}
