package gov.va.cpss.cron;

import static org.junit.Assert.assertEquals;

import org.junit.Test;

import gov.va.cpss.cron.CronUtils;

/**
 * CronUtilsTest Class
 * This class is used to create unit test for CronUtils
 *
 *
 */
public class CronUtilsTest {

    /*
     * Daily Cron at 11:22:33.
     */
    private static final String CRON_EXPR_DAILY = "33 22 11 * * ?";

    /*
     * Daily Time at 11:22:33.
     */
    private static final String TIME_EXPR_DAILY = "11:22:33";
    
    /*
     * Morning Daily Cron at 08:22:33.
     */
    private static final String MORNING_CRON_EXPR_DAILY = "33 22 8 * * ?";

    /*
     * Morning Daily Time at 08:22:33.
     */
    private static final String MORNING_TIME_EXPR_DAILY = "8:22:33";
    
    /*
     * Zero Daily Cron at 00:22:33.
     */
    private static final String ZERO_CRON_EXPR_DAILY = "33 22 0 * * ?";

    /*
     * Zero Daily Time at 00:22:33.
     */
    private static final String ZERO_TIME_EXPR_DAILY = "0:22:33";

    @Test
    public final void testGetCronExpression() {
        assertEquals(CRON_EXPR_DAILY, CronUtils.getCronExpression(TIME_EXPR_DAILY));
    }

    @Test
    public final void testGetTimeFromCronExpression() {
        assertEquals(TIME_EXPR_DAILY, CronUtils.getTimeFromCronExpression(CRON_EXPR_DAILY));
    }
    
    @Test
    public final void testGetCronExpressionMorningHour() {
        assertEquals(MORNING_CRON_EXPR_DAILY, CronUtils.getCronExpression(MORNING_TIME_EXPR_DAILY));
    }
    
    @Test
    public final void testGetTimeFromCronExpressionMorningHour() {
        assertEquals(MORNING_TIME_EXPR_DAILY, CronUtils.getTimeFromCronExpression(MORNING_CRON_EXPR_DAILY));
    }
    
    @Test
    public final void testGetCronExpressionZeroHour() {
        assertEquals(ZERO_CRON_EXPR_DAILY, CronUtils.getCronExpression(ZERO_TIME_EXPR_DAILY));
    }
    
    @Test
    public final void testGetTimeFromCronExpressionZeroHour() {
        assertEquals(ZERO_TIME_EXPR_DAILY, CronUtils.getTimeFromCronExpression(ZERO_CRON_EXPR_DAILY));
    }
}
