<%@ page language="java" contentType="text/html; charset=ISO-8859-1"
	pageEncoding="ISO-8859-1"%>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>

<c:set var="cbssPageTitle" value="CBSS Login" />

<%@include file="header.jsp" %>

<br/>
<br/>
<br/>

<div class="container-fluid">
	<div class="row">
		<div class="col-sm-offset-2 col-sm-8">
			<div class="panel panel-default cbss-box-shadow cbss-panel-background">
				<div class="panel-body">
	      	   		<c:url var="loginUrl" value="/login" />
	      	   		
	      	   		<form action="${loginUrl}" method="post" class="form-horizontal">
	      	   		
						<input type="hidden" name="${_csrf.parameterName}" value="${_csrf.token}" />

						<h2 class="panel-title"><strong>Consolidated Billing Statement System</strong></h2>
						<br />
						<br />
						
						<c:if test="${param.error != null}">
							<div class="alert alert-danger">
								<p>Invalid username and password.</p>
							</div>
						</c:if>
						
						<div class="form-group">
							<label for="username" class="col-sm-3 control-label">User ID:</label>
							<div class="col-sm-7">
								<input aria-labelledby="username" type="text" class="form-control" id="username" name="ssoId" placeholder="User ID" aria-required="true" required />
							</div>
						</div>
						
						<div class="form-group">
							<label for="password" class="col-sm-3 control-label">Password:</label>
							<div class="col-sm-7">
								<input aria-labelledby="password" type="password" autocomplete="off" class="form-control" id="password" name="password" placeholder="Enter Password" aria-required="true" required/>
							</div>
						</div>
						
						<div class="col-sm-offset-9 col-sm-2">
							<button id="Login" type="submit" class="btn btn-primary btn-login" aria-labelledby="Login" title="Login">Login</button>
						</div>
	      	   		</form>
	      	   		
				</div>
			</div>
		</div>
	</div>
</div>


<%@include file="footer.jsp" %>
