<%@ page language="java" contentType="text/html; charset=ISO-8859-1"
	pageEncoding="ISO-8859-1"%>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<!DOCTYPE html>
<html lang="en">
<head>
<%-- Generates common html head, banner and nav bar for CBSS application. --%>
<%-- Pages including this header can define the following page scoped --%>
<%-- variables to override the defaults: --%>
<%-- cbssPageTitle : String --%>
<%-- includeBatchTab : boolean --%>
<%-- includeLogoutTab : boolean --%>
<%-- selectedTab : String (Batch) --%>


<c:if test="${empty cbssPageTitle}">
	<c:set var="cbssPageTitle"
		value="Consolidated Business Statement System (CBSS)" />
</c:if>

<c:if test="${empty selectedTab}">
	<c:set var="selectedTab" value="Batch" />
</c:if>

<meta http-equiv="Content-Type" content="text/html; charset=ISO-8859-1">
<title>${cbssPageTitle}</title>

<link href="<c:url value='/jquery-ui/jquery-ui.min.css' />"
	rel="stylesheet" />
<link href="<c:url value='/bootstrap/css/bootstrap.css' />"
	rel="stylesheet" />
<link href="<c:url value='/cbss/css/app.css' />" rel="stylesheet" />

<script type="text/javascript"
	src="<c:url value='/jquery/jquery-2.1.4.min.js' />"></script>
<script type="text/javascript"
	src="<c:url value='/jquery-ui/jquery-ui.min.js' />"></script>
<script type="text/javascript" 
	src="<c:url value='/jquery-validation/jquery.validate.min.js' />"></script>
<script type="text/javascript"
	src="<c:url value='/bootstrap/js/bootstrap.min.js' />"></script>
<script type="text/javascript"
	src="<c:url value='/javascript/header.js' />"></script>
<script src="sessiontimeout/bootstrap-session-timeout.js"></script>
<script src="sessiontimeout/sessionTimeout.js"></script>
<script type="text/javascript">
    window.history.forward();
    <c:set var="window.timeoutIAMUrl" value="${timeoutGlobalUrl}"/> 
    window.timeoutIAMUrl = '<c:out value="${timeoutGlobalUrl}"/>';
    function noBackFunc() { 
    window.history.forward();
     }
</script>	
</head>
<body onload="noBackFunc();"
    onpageshow="if (event.persisted) noBackFunc();">
  
	<header class="va-banner-container">
		<img width="760" height="55" id="vaBanner"
			alt="United States Department of Veterans Affairs Seal"
			src="<c:url value='/resources/vaBanner.jpg'/>" />
		<span class="version"><c:out value="${version}"/></span>
	</header>
	<nav class="navbar navbar-default">
		<div class="container-fluid">
			<div id="navbar" class="navbar-collapse collapse">

				<c:if test="${includeBatchTab}">
					<ul class="nav navbar-nav">
						<c:choose>
							<c:when test="${selectedTab == 'Batch'}">
								<li class="navbar-active"><a href="#" aria-label="Batch Processes" title="Batch Processes">Batch	Processes</a></li>
							</c:when>
							<c:otherwise>
								<li>
									<c:url var="batchUrl" value="/batch" />
									<form action="${batchUrl}" method="post" id="batchForm">
										<input type="hidden" name="${_csrf.parameterName}"
											value="${_csrf.token}" />
									</form>
									<a href="${pageContext.request.contextPath}/batch"
									class="navbar-nav" aria-label="Batch Processes"
									title="Batch Processes">Batch Processes</a>
								</li>
							</c:otherwise>
						</c:choose>
					</ul>
				</c:if>

				<c:if test="${includeAnnualBatchTab}">
				<ul class="nav navbar-nav">
					<c:choose>
						<c:when test="${selectedTab == 'AnnualBatch'}">
							<li class="navbar-active"><a href="#" aria-label="Annual Processes" title="Annual Processes">Annual Processes</a></li>
						</c:when>
						<c:otherwise>
								<li>
									<a
									href="${pageContext.request.contextPath}/annualProcess"
									class="navbar-nav" aria-label="Annual Processes"
									title="Annual Processes" aria-label="Annual Processes">Annual Processes
									</a>
								</li>
						</c:otherwise>
					</c:choose>
					</ul>
				</c:if>

				<c:if test="${includeLogoutTab}">
					<c:url var="logoutUrl" value="/logout" />
					<form action="${logoutUrl}" method="post" id="logout">
						<input type="hidden" name="${_csrf.parameterName}"
							value="${_csrf.token}" />
					</form>
					<ul class="nav navbar-nav navbar-right">
						<li><a href="${pageContext.request.contextPath}/logout"
						class="navbar-nav" aria-label="LogOff"
						title="LogOff">LogOff</a></li>
					</ul>
				</c:if>
			</div>
		</div>
	</nav>

	<!--  End of Header  -->