<%@ taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c"%>
<%@ taglib prefix="form" uri="http://www.springframework.org/tags/form"%>
<%@ taglib prefix="spring" uri="http://www.springframework.org/tags"%>

<%@ page session="false"%>
<!DOCTYPE html>
<html>
<head>
<title>APPS Batch Run</title>

</head>
<body>
	<div id="appsBatchRunDialog">
		<div class="modal-dialog">
			<div class="modal-content">
				<div class="modal-body">
					<c:choose>
						<c:when test="${empty batchJob}">
							<p>An error occurred. No Batch Process selected.</p>
						</c:when>

						<c:otherwise>
							<h2 class="panel-title" style="text-align: center" >
								<strong>${batchJob.description}</strong>
							</h2>
							<br>

							<p>
								<strong>Batch job will run immediately!
								<br>Click to continue or Cancel to return.
								</strong>
							</p>

							<form:form id="appsBatchRunForm" action="appsBatch/runAppsJob"
								method="post" modelAttribute="batchJob">
								<form:hidden path="id" />
							</form:form>
						</c:otherwise>

					</c:choose>

				</div>

				<div class="modal-footer">
					<c:choose>
						<c:when test="${empty batchJob}">
							<div>
								<button  type="button" class="btn btn-primary"
									data-dismiss="modal" style="width: 80px;">Close</button>
							</div>
						</c:when>
						<c:otherwise>
							<div>
								<button  id="dialog-run-continue" type="button"
									class="btn btn-primary dialog-run-continue"
									data-dismiss="modal" style="width: 80px;">Continue</button>
								<button  type="button" class="btn btn-primary"
									data-dismiss="modal" style="width: 80px;">Cancel</button>
							</div>
						</c:otherwise>
					</c:choose>
				</div>
			</div>
		</div>
	</div>

</body>
</html>