<%@ page language="java" contentType="text/html; charset=ISO-8859-1"
	pageEncoding="ISO-8859-1"%>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>

<c:set var="cbssPageTitle" value="CBSS Batch Processes" />
<c:set var="includeBatchTab" value="${true}" />
<c:set var="includeAnnualBatchTab" value="${true}"/>
<c:set var="includeLogoutTab" value="${true}" />
<c:set var="selectedTab" value="${'Batch'}" />

<%@include file="header.jsp" %>
	<!-- Additional js libraries not included in the header. -->
	<script src="datetimepicker/js/moment.js"></script>
	<script src="datetimepicker/js/bootstrap-datetimepicker.min.js"></script>
	<script type="text/javascript" src="javascript/batch.js"></script>
	<script type="text/javascript" src="javascript/enum.js"></script>

	<!-- Bootstrap modals -->
	<!-- Config Dialog -->
	<div id="dialog-config" class="modal" role="dialog"></div>
	<!-- Run Dialog -->
	<div id="dialog-run" class="modal" role="dialog"></div>

	<c:if test="${pageContext.request.userPrincipal.name != null}">
		<div class="panel panel-default">
		   <div class="panel-heading" tabindex="0">
			 <h2 class="panel-title">Consolidated Billing Statement (CBS) Batch Processes:</h2>
			</div>
			<div class="panel-body">
			<table class="table table-bordered table-hover table-striped table-condensed" role="grid" tabindex="0">
				<caption>Consolidated Billing Statement (CBS) Batch Processes</caption>
				<thead>
					<tr>
						<th scope="col" tabindex="0" id="bpt_header_1" class="text-center row-1 row-Name">Batch Process Name</th>
						<th scope="col" tabindex="0" id="bpt_header_2" class="text-center row-2 row-ScheduledTime">Scheduled Time</th>
						<th scope="col" tabindex="0" id="bpt_header_3" class="text-center row-3 row-Start">Start Date and Time</th>
						<th scope="col" tabindex="0" id="bpt_header_4" class="text-center row-4 row-End">End Date and Time</th>
						<th scope="col" tabindex="0" id="bpt_header_5" class="text-center row-5 row-Status">Status</th>
						<th scope="col" tabindex="0" id="bpt_header_6" class="text-center row-6 row-Action">Action</th>
					</tr>
				</thead>
				<tbody>
				<c:forEach var="batchItem" items="${batchItemL}" varStatus="status1">
					<tr data-job-id="${batchItem.job.id}" id="batch${batchItem.job.id}">
						<td  headers="bpt_header_1" class="text-left bJobName bConfigClick">
							<a tabindex="0" class="hrefConfigClick" data-job-id="${batchItem.job.id}">${batchItem.job.description}</a>
								<!--<c:out value="${batchItem.job.description}"/>
							</a>-->
						</td>
						<td tabindex="0" headers="bpt_header_2" class="text-center bSchedule">${batchItem.job.schedule}</td>
						<td tabindex="0" headers="bpt_header_3" class="text-center bStart">${batchItem.run.serverStartDateString}</td>
						<td tabindex="0" headers="bpt_header_4" class="text-center bEnd">${batchItem.run.serverEndDateString}</td>
						<td headers="bpt_header_5" class="text-center bStatusClick" >
							<a tabindex="0" class="hrefStatusClick" href="${pageContext.request.contextPath}/batchStatus/${batchItem.job.id}" >
								<c:out value="${batchItem.run.batchStatus.description}"/>
								<c:if test="${batchItem.run.batchStatus.jobStatus == 'ERROR'}">
									<img src='resources/notice.png' alt='Notice!' />
								</c:if>
							</a>
						</td>
						<td headers="bpt_header_6" class="text-center bActionClick">
							<c:choose>
								<c:when test="${batchItem.run.batchStatus.jobStatus == 'RUNNING'}">
									<span tabindex="0" class="disabled-link" aria-label="Link Run">Run</span>
								</c:when>
								<c:otherwise>
									<a tabindex="0" class="hrefActionClick" data-job-id="${batchItem.job.id}" aria-label="Link to Run ${batchItem.job.id}">Run</a>
								</c:otherwise>
							</c:choose>
						</td>
					</tr>
				</c:forEach>
				</tbody>
			</table>
		   </div>
		</div>
	</c:if>

<%@include file="footer.jsp" %>