<%@ page language="java" contentType="text/html; charset=ISO-8859-1"
	pageEncoding="ISO-8859-1"%>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@ taglib uri="http://java.sun.com/jsp/jstl/functions" prefix="fn"%>
<c:set var="cbssPageTitle" value="CBSS Batch Status" />
<c:set var="includeBatchTab" value="${true}" />
<c:set var="includeAnnualBatchTab" value="${true }"/>
<c:set var="includeLogoutTab" value="${true}" />
<c:set var="selectedTab" value="${'BatchStatus'}" />

<%@include file="header.jsp"%>

<div id="batchStatusForm">
	<div class="panel panel-default">
		<div class="panel-heading">
			<h2 class="panel-title" id=batchStatusInfo aria-label="Status" >
				<strong>Status:</strong> <br>
				<br>
			</h2>

			<div>
				<span aria-label="Batch Process Name: ${batchItem.job.description}">Batch Process Name: ${batchItem.job.description}</span>
				<br>
				<span aria-label="Start: ${batchItem.run.serverStartDateString}">Start: ${batchItem.run.serverStartDateString}</span>
				<br>
				<span aria-label="End: ${batchItem.run.serverEndDateString}">End: ${batchItem.run.serverEndDateString}</span>
				<br>
				<span aria-label="Status: ${batchItem.run.batchStatus.description}">Status: ${batchItem.run.batchStatus.description} </span>
					<div class="ScrollStyle">
					<c:set var="message" value="${batchItem.run.message}" />
					<c:set var="newline" value="<%=\"\n\"%>" />
					<c:set var="splitMessage"
						value="${fn:replace(message,newline, '<br />')}" />
					<span>${splitMessage}</span>
				</div>
				<span style="display:none" aria-label="Run#: ${batchItem.run.id}">Run#: ${batchItem.run.id}</span>

				<div>
					<button class="btn btn-default backBtn"
						onclick="location.href='${pageContext.request.contextPath}/annualProcess'" aria-label="Return to APPS Batch Processes" title="Return to APPS Batch Processes" >Return to APPS Batch Processes</button>
						<!--
						onclick="location.href='${pageContext.request.contextPath}/annualProcess'" aria-label="Back" title="Back">Back</button>
						-->
				</div>
				<br> <br> <br>
			</div>
		</div>
	</div>
</div>

<%@include file="footer.jsp"%>
