package gov.va.cpss.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Properties;

import org.apache.log4j.Logger;

/**
 * 
 * Utility class providing static convenience methods. The origin for this class
 * was to provide the version number for displayin upper right corner of header.
 * 
 * Copyright HPE / VA April 10, 2017
 * 
 * @author James Garnhart
 * 
 */
public class CpssUtils {

	private static String version;

	public static String getVersion() {

		if (version == null) {

			Properties prop = new Properties();
			BufferedReader input = null;

			try {

				InputStream stream = CpssUtils.class.getResourceAsStream("/version.properties");

				input = new BufferedReader(new InputStreamReader(stream));

				prop.load(input);

				version = "version " + prop.getProperty("version");

			} catch (final IOException ex) {

				version = "";

				Logger.getLogger(CpssUtils.class).error("Unable to read file version.properties");

				ex.printStackTrace();

			} finally {
				if (input != null) {
					try {
						input.close();
					} catch (final IOException e) {
						e.printStackTrace();
					}
				}
			}

		}

		return version;
	}

	/**
	 * Breaking the 16 digits combination "DFN-Number" of Station Number (first 3
	 * digits) and DFN Number into (Station Number and) actual DFN Number
	 * 
	 * @param longDfnNumber
	 * @return DFN number
	 */
	public static long getDfnNumber(long longDfnNumber) {
		long dfn = longDfnNumber;

		String strDfn = String.valueOf(longDfnNumber);
		if (strDfn != null) {
			if (strDfn.length() == 16) {
				strDfn = String.valueOf(strDfn).substring(3);
				dfn = Long.valueOf(strDfn).longValue();
			}
		}

		return dfn;
	}

}
