package gov.va.cpss.time;

import java.text.SimpleDateFormat;
import java.util.Date;

/**
 * Static utilities relating to time.
 * 
 * @author DNS   
 */
public final class TimeUtils {

	private TimeUtils() {
	}

	/**
	 * Get a timestamp string using the specified format.
	 * 
	 * @param format
	 *            The format for the timestamp.
	 * @return String timestamp for the current time.
	 */
	public static String getTimestamp(final String format) {
		Date date = new Date();
		SimpleDateFormat sdf = new SimpleDateFormat(format);
		return sdf.format(date);
	}

}
