package gov.va.cpss.service.impl.vfs;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;

import org.apache.log4j.Logger;

import gov.va.cpss.service.SftpConnectionProperties;

import static gov.va.cpss.ESAPI.EsapiValidator.validateStringInput;
import static gov.va.cpss.ESAPI.EsapiValidationType.LOG_FORGING;

/**
 * Implementation of the SftpConnectionProperties for Apache VFS.
 * 
 * @author Brad Pickle
 *
 */
public class VfsSftpConnectionPropertiesImpl implements SftpConnectionProperties {

	private static final Logger logger = Logger.getLogger(VfsSftpConnectionPropertiesImpl.class.getCanonicalName());

	private String host;

	private String username;

	private String password;

	private String encodedBaseUri;

	private String privateKey;

	private boolean isEncodedBaseUriSet = false;

	@Override
	public String getHost() {
		return host;
	}

	@Override
	public void setHost(String host) {
		this.host = host;
		isEncodedBaseUriSet = false;
	}

	@Override
	public String getUsername() {
		return username;
	}

	@Override
	public void setUsername(String username) {
		this.username = username;
		isEncodedBaseUriSet = false;
	}

	@Override
	public String getPassword() {
		return password;
	}

	@Override
	public void setPassword(String password) {
		this.password = password;
		isEncodedBaseUriSet = false;
	}

	@Override
	public String getPrivateKey() {
		return privateKey;
	}

	@Override
	public void setPrivateKey(String privateKey) {
		this.privateKey = privateKey;
	}

	@Override
	public String getEncodedBaseUri() {
		if (!isEncodedBaseUriSet)
			setEncodedBaseUri();
		return encodedBaseUri;
	}

	private void setEncodedBaseUri() {
		String encodedUser = encode("USERNAME", username);
		String encodedAuthorization = encode("AUTHORIZATION", password);
		encodedBaseUri = SFTP_URL_PREFIX + encodedUser + COLON + encodedAuthorization + AT_SIGN + host;
		isEncodedBaseUriSet = true;
	}

	private String encode(String fieldName, String rawVal) {
		String encodedVal = "";

		try {
			encodedVal = (rawVal == null) ? "" : URLEncoder.encode(rawVal, "UTF-8");
		} catch (UnsupportedEncodingException uee) {
			logger.error(
					"Unable to encode " + validateStringInput(fieldName, LOG_FORGING) + " for sFTP Connection URI.",
					uee);
		}

		return encodedVal;
	}

}
