package gov.va.cpss.service.impl.vfs;

import java.io.IOException;

import org.apache.commons.vfs2.FileObject;

import gov.va.cpss.service.SftpSession;

/**
 * Implementation of an SftpSession for Apache VFS. The session is encapsulated
 * within an open Apache VFS FileObject for a file on the sFTP Server.
 * 
 * @author Brad Pickle
 *
 */
public class ApacheVfsSftpSessionImpl implements SftpSession {

	private FileObject remoteFileObject = null;

	/**
	 * Create an SftpSession for the given open FileObject for a file on the
	 * sFTP Server.
	 * 
	 * @param remoteFileObject
	 *            Open FileObject for a file on the sFTP Server.
	 */
	public ApacheVfsSftpSessionImpl(FileObject remoteFileObject) {
		this.remoteFileObject = remoteFileObject;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see gov.va.cpss.service.SftpSession#close()
	 */
	@Override
	public void close() throws IOException {
		if (remoteFileObject != null) {
			remoteFileObject.close();
			remoteFileObject = null;
		}
	}

}
