package gov.va.cpss.service;

import org.apache.log4j.Logger;
import org.springframework.stereotype.Service;

import gov.va.cpss.dao.CBSAccountDAO;
import gov.va.cpss.dao.ProcessStatusDAO;
import gov.va.cpss.dao.VistaAccountDAO;
import gov.va.cpss.model.ProcessStatus;
import gov.va.cpss.model.icn.VistaAccount;

/**
 * Service class for handling activities relating to consolidating a patient
 * statement.
 * 
 * @author DNS   
 */
@Service
@SuppressWarnings("nls")
public class VistaAccountService {

	private static final Logger logger = Logger.getLogger(VistaAccountService.class.getCanonicalName());

	private CBSAccountDAO cbsAccountDAO;

	private VistaAccountDAO vistaAccountDAO;

	private ProcessStatusDAO processStatusDAO;

	public CBSAccountDAO getCbsAccountDAO() {
		return this.cbsAccountDAO;
	}

	public void setCbsAccountDAO(CBSAccountDAO inCbsAccountDAO) {
		this.cbsAccountDAO = inCbsAccountDAO;
	}

	public VistaAccountDAO getVistaAccountDAO() {
		return this.vistaAccountDAO;
	}

	public void setVistaAccountDAO(VistaAccountDAO inVistaAccountDAO) {
		this.vistaAccountDAO = inVistaAccountDAO;
	}

	public ProcessStatusDAO getProcessStatusDAO() {
		return this.processStatusDAO;
	}

	public void setProcessStatusDAO(ProcessStatusDAO inProcessStatusDAO) {
		this.processStatusDAO = inProcessStatusDAO;
	}

	public VistaAccount getAccountRecord(final long dfn, final String stationNum) {
		return this.vistaAccountDAO.getVistaAccount(dfn, stationNum);
	}

	/**
	 * Get the account number associated with this ICN.
	 * 
	 * @param icn
	 *            The ICN to associate with an account number.
	 * @return The existing or new account number.
	 */
	public long getAccountNumberForICN(final String icn) {

		return this.cbsAccountDAO.getByICN(icn).longValue();
	}

	public String getICNForAccountNumber(final long cbssAcntId) {

		return this.cbsAccountDAO.selectICNById(cbssAcntId);
	}

	/**
	 * Register the account for the specified vista record.
	 * 
	 * @param psPatient
	 *            The patient to register.
	 * @return Flag indicating if successfully registered or not.
	 */
	public boolean registerAccount(final VistaAccount vistaAccount) {

		boolean successful = false;

		Integer newStatus = this.processStatusDAO.getStatusFromEnum(ProcessStatus.Status.NEW);

		if (newStatus != null) {

			// Temporary fix for the DFN Number issue
			// - Breaking the 16 digits combination "DFN-Number" of Station Number (first 3 digits) and DFN Number
			//   into (Station Number and) actual DFN Number
			// Yiping Yao - 02/27/2018
			String dfnCombination = String.valueOf(vistaAccount.getDfn());
			long dfn = 0L;

			if (dfnCombination != null)
			{
				if (dfnCombination.length() == 16)
				{
					String strDFN = String.valueOf(dfnCombination).substring(3);
					dfn = Long.valueOf(strDFN).longValue();
				}
				else
				{
					dfn = vistaAccount.getDfn();
				}

				successful = this.vistaAccountDAO.save( newStatus.intValue(), dfn, vistaAccount.getStationNum(),
														vistaAccount.getIcn(), vistaAccount.getCbssAcntId() );
			}
		} else {

			logger.error("Unable to obtain status mapping for: " + ProcessStatus.Status.NEW);
		}

		return successful;
	}
}
