package gov.va.cpss.service;

import java.util.Map;

import gov.va.cpss.model.updatestation.StationInfo;

public class StationInfoUtil
{
    private static StationInfoService stationInfoService;

    /**
     * @return the service
     */
    public static StationInfoService getStationInfoService()
    {
        return stationInfoService;
    }

    /**
     * @param inService the service to set
     */
    public static void setStationInfoService(StationInfoService inService)
    {
        StationInfoUtil.stationInfoService = inService;
    }

    private static Map<String, StationInfo> stationInfoMap;

    /**
     * @return
     */
    public static synchronized Map<String, StationInfo> getStationInfoMap()
    {
        if (stationInfoMap == null)
        {
            stationInfoMap = stationInfoService.getStationMap();
        }

        return stationInfoMap;
    }

    /**
     * Returns the StationInfo object for the respective station number.
     * 
     * @param stationNum
     *            The station (facility) number
     */
    public static StationInfo getStation(String stationNum)
    {
        return getStationInfoMap().get(stationNum);
    }

	/**
	 * Returns the size of the StationInfo map
	 */
	public static int getTotalNumberOfStations()
	{
		return (getStationInfoMap() == null) ? 0 : getStationInfoMap().size();
	}
	
    /**
     * Returns whether the Station is valid or not.
     */
    public static boolean isValidStation(String stationNum)
    {
        return getStationInfoMap().containsKey(stationNum);
    }
}
