package gov.va.cpss.service;

import java.io.IOException;
import java.io.InputStream;

import org.apache.log4j.Logger;

/**
 * Encapsulates an active SftpSession and InputStream for reading contents of a
 * remote file. After reading the contents from the InputStream, a client should
 * call close() to close the InputStream and Session.
 * 
 * @author DNS 
 *
 */
public class SftpStreamSession {

	private static final Logger logger = Logger.getLogger(SftpStreamSession.class.getCanonicalName());

	private SftpSession session;

	private InputStream inputStream;

	/**
	 * Create an SftpStreamSession with the given SftpSession and InputStream
	 * representing an open session to an Sftp Server for reading the contents
	 * of a remote file.
	 * 
	 * @param session
	 *            SftpSession representing an open session to the Sftp Server
	 *            for reading the contents of a remote file.
	 * @param inputStream
	 *            An open InputStream used for reading the contents of the
	 *            remote file.
	 */
	public SftpStreamSession(SftpSession session, InputStream inputStream) {
		this.session = session;
		this.inputStream = inputStream;
	}

	/**
	 * Get the InputStream for reading the contents of the remote file.
	 * 
	 * @return InputStream for reading the contents of the remote file.
	 */
	public InputStream getInputStream() {
		return inputStream;
	}

	/**
	 * Closes the InputStream and SftpSession. Should be called by the client
	 * after the file contents have been read from the InputStream.
	 */
	public void close() {
		if (inputStream != null) {
			try {
				inputStream.close();
				inputStream = null;
			} catch (IOException e) {
				logger.error("Unexpected exception when closing input stream: " + e.getMessage());
			}
		}
		if (session != null) {
			try {
				session.close();
				session = null;
			} catch (IOException e) {
				logger.error("Unexpected exception when closing sFTP session: " + e.getMessage());
			}
		}
	}

}
